/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Feb 2000)
** Modified by : J. HUMMEL to collect multiple volume data node (Apr 2005)
**=======================================================================*/


#ifndef  _SO_VOLUME_DATA_ELEMENT_
#define  _SO_VOLUME_DATA_ELEMENT_

#include <LDM/elements/SoDataSetElement.h>
#include <VolumeViz/nodes/SoVolumeData.h>

//wrapper
/**
 * @ingroup VolumeVizElements
 */
class VOLUMEVIZ_API SoVolumeDataElement : public SoDataSetElement {

public:
  static void set(SoState* state, SoNode *node, SoVolumeData *volumeDataNode)
  {
    SoDataSetElement::set(state, node, (SoDataSet*)volumeDataNode);
  }

  static void set(SoState *state, SoNode *node,
                  SoVolumeData *volumeDataNode, const SbMatrix &matrix )
  {
    SoDataSetElement::set(state, node, (SoDataSet*)volumeDataNode, matrix);
  }

  static void get(SoState* state, std::vector<SoVolumeData*>& s)
  {
    std::vector<SoDataSet*> temp;
    SoDataSetElement::get(state, temp);
    for(unsigned int i = 0 ; i < temp.size() ; i++ ){
      s.push_back((SoVolumeData*)temp[i]);
    }
  }

  /** [OIVJAVA-WRAPPER NAME{getVolumeData}] */
  static void get(SoState* state, SoVolumeData*& vd)
  {
    std::pair<SoVolumeData*, int> p = SoDataSetElement::getLastOfType<SoVolumeData>(state, true);
    vd = p.first;
  }

  static const SbMatrix &get(SoState *state, SoVolumeData*& v, SbBool &isIdent )
  {
    return SoDataSetElement::get(state, (SoDataSet*&)v, isIdent);
  }
};

#endif // _SO_VOLUME_DATA_ELEMENT_


