/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Sep 2008)
**=======================================================================*/


#ifndef  _SO_VOLUME_TRANSFORM_ELEMENT_
#define  _SO_VOLUME_TRANSFORM_ELEMENT_

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <Inventor/elements/SoAccumulatedElement.h>

#include <VolumeViz/nodes/SoVolumeTransform.h>
#include <Inventor/STL/vector>

/**
 * Stores the current volume transform(s).
 *
 * @ingroup VolumeVizElements
 *
 * @DESCRIPTION
 * This element stores pointers to the volume transform node
 * currently in the traversal state.
 *
 * @SEE_ALSO
 * SoVolumeTransform
 */
SoEXTENDER_Documented class VOLUMEVIZ_API SoVolumeTransformElement : public SoAccumulatedElement 
{
  SO_ELEMENT_HEADER( SoVolumeTransformElement );

public:
  /**
   * Add a volume transform to the state.
   */
  static void set(SoState* state, SoNode *node, SoVolumeTransform *m_volumeTransformNode);

  /**
   * Returns most recently traversed volume transform from the state.
   */
  static void get(SoState* state, SoVolumeTransform *&m_volumeTransformNode);
  
  /**
   * Get the current list of transform functions stored in the state
   */
  static void get(SoState* state, std::vector<SoVolumeTransform*>&);

  /** Overrides push() method to copy values from next instance in the stack */
  virtual void push(SoState *state) ;

protected:

  /** Initializes element */
  virtual void init(SoState* state);

SoINTERNAL public:
  // Initializes the class
  static void initClass();
  static void exitClass();

  // Default values
  static void getDefault(SoVolumeTransform *&m_volumeTransformNode);

protected:

  //List of transfer function.
  //Each compute function is stored at cf->volumeTransformId entry in this array
  //If volumeTransformId are different, transfer functions are accumulated else replaced
  std::vector<SoVolumeTransform*> m_volumeTransformList;

  SoVolumeTransform *m_volumeTransformNode;

  virtual void setElt( SoVolumeTransform *m_volumeTransformNode );

  virtual ~SoVolumeTransformElement() ;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_VOLUME_TRANSFORM_ELEMENT_


