/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  SO_HEIGHTFIELD_PROPERTY_H
#define  SO_HEIGHTFIELD_PROPERTY_H

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

#include <VolumeViz/nodes/SoVolumeData.h>

#include <Inventor/fields/SoMFDouble.h>
#include <Inventor/fields/SoSFFloat.h>

SO_PIMPL_PUBLIC_DECLARATION(SoHeightFieldProperty)

/**
* @VREXT Height field property node.
*
* @ingroup VolumeVizNodes
*
* @DESCRIPTION
* SoHeightFieldProperty defines a set of values on a uniform grid in the XY plane
* that can be used to color an SoHeightFieldGeometry when rendered using an
* SoHeightFieldRender node.
*
* SoHeightFieldProperty is derived from SoVolumeData and serves a similar purpose
* in the scene graph, providing a reference to an LDM data set which will be
* loaded as needed by rendering nodes, specifically SoHeightFieldRender in this case.
*
* The property data is given using the inherited field #fileName or by using a custom reader
* through the #setReader method.
*
* Multiple SoHeightFieldProperty nodes can be inserted in a scene graph and combined
* together in the GPU to do render compositing. However the default fragment shader 
* only handles one property (the first one).  To combine multiple properties use a 
* custom shader program (see SoVolumeShader and the example program).
*
* Note that it is not necessary (or useful) to set the inherited extent field.
* SoHeightFieldRender will use the extent associated with the SoHeightFieldGeometry node.
*
* Also note that the inherited undefinedValue field is ignored. Setting it has no effect.
*
* @FILE_FORMAT_DEFAULT
*    HeightFieldProperty {
*    @TABLE_FILE_FORMAT
*       @TR allocateResourceOnRender   @TD FALSE
*       @TR data                       @TD NODATA 0 0 0 UBYTE 8
*       @TR dataRGBA                   @TD FALSE
*       @TR dataSetId                  @TD 1
*       @TR dataTransform              @TD NULL
*       @TR extent                     @TD -1 -1 -1 1 1 1
*       @TR fileName                   @TD ""
*       @TR texturePrecision           @TD 0
*       @TR undefinedValue             @TD NaN
*       @TR useCompressedTexture       @TD TRUE
*       @TR useExtendedData            @TD FALSE
*       @TR usePalettedTexture         @TD TRUE
*       @TR useSharedPalettedTexture   @TD TRUE
*    @TABLE_END
*    }
*
* @SEE_ALSO
*    SoHeightFieldRender,
*    SoHeightFieldGeometry,
*    SoMultiDataSeparator,
*    SoConverter
*
*
*/
class VOLUMEVIZ_API SoHeightFieldProperty : public SoVolumeData
{
  SO_NODE_HEADER( SoHeightFieldProperty );

  SO_PIMPL_PUBLIC_HEADER( SoHeightFieldProperty );

public:
  SoHeightFieldProperty();

SoINTERNAL public:
  static void initClass();
  static void exitClass();
  virtual void notify(SoNotList* list);

protected:
  virtual ~SoHeightFieldProperty();

private:
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // SO_HEIGHTFIELD_PROPERTY_H


