/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Mar 2000)
**=======================================================================*/
#ifndef  _SO_VOLUME_RENDERING_
#define  _SO_VOLUME_RENDERING_

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4251)
#  pragma warning(disable:4244)
#endif

#include <VolumeViz/SoVolumeVizLibName.h>

// On Windows the "comment" pragma will automatically add our Volume
// Rendering library to the application's link string.
#ifdef _WIN32
#  ifndef VolumeViz_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__VOLUMEVIZLIB)
#    endif
#  endif
#endif // _WIN32

#include <Inventor/nodes/SoSubNode.h>
#include <LDM/SoLDMGlobalResourceParameters.h>
#include <LDM/nodes/SoHardwareQuery.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoVolumeViz, __VOLUMEVIZDLL)

class SoLDMTileManager;

/**
 * @VREXT Initializes the VolumeViz module database.
 * 
 * @ingroup VolumeVizNodes
 * 
 * @DESCRIPTION
 *   This abstract class is the base class for all volume rendering modules. It is
 *   used only for initializing the VolumeViz extension and setting some global
 *   parameters.
 *
 *   \if_cpp
 *   The init() method must be called before creating any VolumeViz nodes.
 *   The finish() method should be called when the application is shutting down.
 *   \endif
 *
 * @B Limitations:@b
 *   - Multi-thread rendering: @BR
 *     Unlike most Open Inventor nodes, VolumeViz nodes do not support simultaneous
 *     rendering in multiple threads (even when Open Inventor is initialized using 
 *     one of the initThread() methods).
 * 
 * @SEE_ALSO
 *    SoVolumeData,
 *    SoTransferFunction,
 *    SoVolumeRender,
 *    SoOrthoSlice,
 *    SoObliqueSlice,
 *    SoROI,
 *    SoVolumeReader,
 *    SoLDMGlobalResourceParameters
 * 
 */
class VOLUMEVIZ_API SoVolumeRendering {

 public:
  /**
   * Initializes the VolumeViz module database. This must be called before the
   * construction of any VolumeViz nodes.
   * 
   * Generally this method should be called immediately after initializing
   * Open Inventor. In other words just after SoXt::init(), SoWin::init(), etc.
   *
   * Starting with Open Inventor version 8.5, this method @B must @b called
   * before any instances of SoSceneManager are created.  When using the Open
   * Inventor viewer classes, an SoSceneManager is created automatically when
   * the viewer is created.  So this method should be called before creating
   * the viewer.
   * 
   * \code 
   *    SoXt::init(); 
   *    SoVolumeRendering::init(); 
   *    ... \endcode
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void		init();

  /** 
   * Shuts down the VolumeViz module, which includes freeing any
   * internal static memory that it allocated. 
   * Finish methods must be called in the reverse order of the init method calls: 
   * \code    
   *    SoVolumeRendering::finish(); 
   *    SoXt::finish(); 
   *    ... \endcode
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static bool isInitialized();

  ////////////////////////////////////////////////////////////////////////////////
  // Alternate Representation section

  /**
   * Sets the @B writeAlternateRep @b flag. @BR
   * When this flag is TRUE during an SoWriteAction traversal, some
   * VolumeViz nodes will write an @B alternateRep @b subgraph
   * containing only standard Open Inventor nodes that can be rendered
   * even without VolumeViz.  For example, SoOrthoSlice will write an
   * SoTexture2 node and an SoFaceSet node.
   * The default is FALSE.
   */
  static void   setWriteAlternateRep( SbBool flag );

  /**
   * Returns the @B writeAlternateRep @b flag.
   */
  static SbBool getWriteAlternateRep();

  /**
   * Sets the @B readAlternateRep @b flag. <br>
   * When this flag is TRUE while reading an Open Inventor file, any
   * @B alternateRep @b subgraphs attached to VolumeViz nodes are read and
   * added to the scene graph. Otherwise, @B alternateRep @b subgraphs are discarded
   * and the @B alternateRep @b field is set to NULL. The default is FALSE.
   */
  static void   setReadAlternateRep( SbBool flag );

  /**
   * Returns the @B readAlternateRep @b flag.
   */
  static SbBool getReadAlternateRep();

  /**
   * Hardware Features Mode 
   */
  enum HW_Feature {
  /**
   *  The system supports OpenGL 3D texture mapping.
   * On some boards, this query may return TRUE even
   * if your board does not support accelerated
   * 3D textures. In this case performance may
   * be slow, and you may prefer to use
   * 2D textures instead. Note: The inability
   * to determine if 3D textures are accelerated 
   * is a limitation of OpenGL, not Open Inventor.
   */
    HW_3DTEXMAP = SoHardwareQuery::HW_3DTEXMAP,
  /**
   *  The system supports the OpenGL paletted
   *  texture extension and/or the texture color table
   *  extension. 
   */
    HW_TEXCOLORMAP = SoHardwareQuery::HW_TEXCOLORMAP,
  /**
   *  The system supports the OpenGL texture
   *  compression extension.
   */
    HW_TEXCOMPRESSION = SoHardwareQuery::HW_TEXCOMPRESSION
  };

  /**
   * Hardware Features support status
   */
  enum HW_SupportStatus {
    /** Not supported */
    NO = SoHardwareQuery::NO,
    /** Supported */
    YES,
    /** unknown status */
    UNKNOWN
  };

  /**
   * Returns information about hardware support for various volume rendering
   * features. This query is only valid after SoVolumeRendering::init has been
   * called. Otherwise the return value will be UNKNOWN.
   *
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static HW_SupportStatus isSupported( HW_Feature feature );

#if SoDEPRECATED_BEGIN(9000)

  /**
   * Sets the @B delayedRendering @b flag. Default is FALSE.@BR
   * When this flag is TRUE , VolumeViz drawing nodes (e.g., SoOrthoSlice) are
   * rendered in a delayed pass (until after all opaque objects) and/or sorted
   * according to the current transparency type (see SoGLRenderAction).
   * This may result in a more correct image if there is opaque geometry
   * intersecting the volume.
   * However delayed/sorted rendering may slightly decrease performance.
   * This flag may also be set using the IVVR_DELAY_RENDER environment variable.
   */
  SoDEPRECATED_METHOD(9000,"This is now automaticaly done only if necessary.")
  static void setDelayedRendering( SbBool flag );

  /**
   * Returns the @B delayedRendering @b flag.
   */
  SoDEPRECATED_METHOD(9000,"No longer used.")
  static SbBool getDelayedRendering();

#endif /** @DEPRECATED_END */

 //////////////////////////////////////////////////////////////////////////////
 SoINTERNAL public:

  enum Cmd{
    SET_WRITE_ALTERNATE_REP = 0,
    SET_READ_ALTERNATE_REP,
    SET_DELAYED_RENDERING,
    SET_IGNORE_FULLY_TRANSPARENT_TILES,
    SET_MOVE_LOW_RES
  };
  
  SoVolumeRendering();

private:
  // ------------------------------------------------------------

  static SbBool s_writeAlternateRep;  // write classic Inventor nodes
  static SbBool s_readAlternateRep;   // keep altRep when reading file
  static SbBool s_delayedRendering;   // enable delayed rendering
  static int    s_debugFlag;          // internal debug flag

  static int s_initRefCount;          // module ref counter

  static const char* s_versionString;
};

#if defined(_WIN32)
#pragma warning( pop )
#endif

#endif // _SO_VOLUME_RENDERING_


