/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : G. SEGUIN (Nov 2001)
**=======================================================================*/
#ifndef  _SO_VR_AM_FILE_READER_
#define  _SO_VR_AM_FILE_READER_

#include <LDM/readers/SoVolumeReader.h>
#include <VolumeViz/nodes/SoVolumeData.h>


/**
 * @VREXT Am file reader.
 * 
 * @ingroup VolumeVizReaders
 * 
 * @DESCRIPTION
 * 
 * AmiraMesh file format. 
 * 
 *   Amira mesh is a general purpose file format that can contain many
 *   different kinds of data.  This is the native file format for the
 *   Amira and Avizo applications (http://www.amira.com).  Many other
 *   visualization and analysis applications import and export this format.
 * 
 *   The VolumeViz file reader can load Amira mesh files containing a 
 *   3-dimensional "Lattice" data object with uniform coordinates and any data type.
 * 
 *   Note: VolumeViz cannot automatically open Amira/Avizo format data files unless
 *   they have the file name extension ".am".  To open an Amira/Avizo data file
 *   with a different extension, the application must explicitly create an instance
 *   of this reader and use the SoVolumeData method setReader().
 *
 *   LIMITATIONS:
 *   - Currently cannot load RLE encoded volume data.
 * 
 */
class VOLUMEVIZ_API SoVRAmFileReader : public SoVolumeReader
{

  SO_FIELDCONTAINER_HEADER(SoVRAmFileReader);

 public:
  /** Constructor. */
  SoVRAmFileReader(); 

  /**
   * @copydoc SoVolumeReader::getDataChar(SbBox3f&,SoDataSet::DataType&,SbVec3i32&)
   */
  virtual ReadError getDataChar( SbBox3f &size, SoDataSet::DataType &type,  SbVec3i32 &dim ) override;

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,void*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void * data );

  /**
   * Returns the reader type.
   */
  virtual SoVolumeReader::ReaderType getReaderType ()
  {return AM;};

  int getHeaderSize();

  /**
   * Returns TRUE if the data set contains RGBA color values.
   */
  virtual SbBool isRGBA() const;

SoINTERNAL public:
  /**
   * Returns the matrix of directions cosines.
   */
  SbMatrix getTransform();

 private:
  SbVec3i32 m_dim;
  SbBox3f m_size;
  SoDataSet::DataType m_type;

  int m_headerSize;
  bool m_isLittleEndian;
  bool m_isInitialized;
  SbMatrix m_transform;
};

#endif // _SO_VR_AM_FILE_READER_


