/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : J.HUMMEL (Oct 2003)
**=======================================================================*/
#ifndef  _SO_VR_MEMORY_READER_
#define  _SO_VR_MEMORY_READER_

#include <LDM/readers/SoVolumeReader.h>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

class SoBufferObject;

/**
 * @VREXT Reads volume data stored in memory.
 *
 * @ingroup VolumeVizReaders
 *
 * @DESCRIPTION
 *
 *
 *
 */
class VOLUMEVIZ_API SoVRMemoryReader : public SoVolumeReader
{

  SO_FIELDCONTAINER_HEADER(SoVRMemoryReader);

public:

  /**
   * Constructor.
   */
  SoVRMemoryReader();

  /**
  * @copydoc SoVolumeReader::getDataChar(SbBox3f&,SoDataSet::DataType&,SbVec3i32&)
  */
  virtual ReadError getDataChar( SbBox3f &size, SoDataSet::DataType &type,  SbVec3i32 &dim ) override;

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,void*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void * data );

  /** 
   * Same as getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void * data )
   * but using SoBufferObject as parameter. 
   */
  virtual void getSubSlice(const SbBox2i32& subSlice, int sliceNumber, SoBufferObject * dataBuffer);

  /**
   * Sets properties of the reader.
   */
  void setProperties ( const SbBox3f& size, SoDataSet::DataType type, const SbVec3i32 &dim,
                       const SbVec2i32 &padding, SoBufferObject* internalData, int sigBits);

  /** 
   * Sets properties of the reader.
   */
  void setProperties ( const SbBox3f& size, SoDataSet::DataType type, const SbVec3i32 &dim,
                       SoBufferObject* internalData, int sigBits);

  /** 
   * Sets properties of the reader.
   */
  void setProperties ( SbBox3f size, SoDataSet::DataType type, SbVec3s dim,
                       SoBufferObject* internalData, int sigBits = 0);
  /**
   * Returns the number of significant bits of the volume data.
   */
  virtual int getNumSignificantBits();

  /**
   * Returns the reader type.
   */
  virtual SoVolumeReader::ReaderType getReaderType ()
  {return MEMORY;}

  /**
   * Return true as this reader is thread safe.
   */
  virtual SbBool isThreadSafe() const;

  /** Return a writer with the same parameters as this reader and writing in 
   * the same block of memory. */
  virtual SoVolumeWriter* getConfiguredWriter();

SoINTERNAL public:
  SoBufferObject* getInternalBuffer() const
  {
    return m_internalBuffer.ptr();
  }

  const SbVec2i32& getPadding() const
  {
    return m_padding;
  }

private:
  SbBox3f                m_size;
  SbVec3i32              m_dim;
  SbVec2i32              m_padding;
  SoDataSet::DataType m_type;
  int                    m_headerSize;
  SoRef<SoBufferObject>  m_internalBuffer;
  int                    m_sigBits;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_VR_MEMORY_READER_


