/*=================================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
***                                                                            ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
***                                                                            ***
***                        RESTRICTED RIGHTS LEGEND                            ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
***                                                                            ***
***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                    ***
***                              BORDEAUX, FRANCE                              ***
***                            ALL RIGHTS RESERVED                             ***
=================================================================================*/

#pragma once

#include <LDM/readers/SoVolumeReader.h>
#include <Inventor/SbPImpl.h>

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoVRMrcFileReader);

/**
 * @VREXT MRC file reader.
 *
 * @ingroup VolumeVizReaders
 *
 * @DESCRIPTION
 *
 * Volume reader for the MRC file format.
 *
 * MRC is a file format that has become industry standard in cryo-electron microscopy
 * (cryoEM) and electron tomography (ET), where the result of the technique is a
 * three-dimensional grid of voxels each with a value corresponding to electron density
 * or electric potential. It was developed by the MRC (Medical Research Council, UK)
 * Laboratory of Molecular Biology. In 2014, the format was standardised. The format
 * specification is available on the CCP-EM website.  For details see:
 * http://www.ccpem.ac.uk/mrc_format/mrc2014.php
 *
 * SoVolumeData automatically selects this reader if a filename is given and the file
 * extension is ".mrc".  The application can also explicitly create an instance of
 * this reader and call the SoVolumeData method setReader().
 *
 * SoVRMrcFileReader loads slices from a single multi-image MRC file.
 * To load a volume from multiple MRC files, see the SoVRRasterStackReader class.
 *
 * All the images contained in the file should have the same size.
 * If it is not the case, the reader will find the largest image and take all images
 * with the same size.
 *
 * @B Supported:@b
 * - Color index volume, or
 * - RGBA volume with unsigned byte components (not RGBA).
 *
 * For more information about volume readers see SoVolumeReader.
 *
 * <b>NOTE</b>: Class available since Open Inventor 10.4.
 *
 * @SEE_ALSO
 *    SoVolumeReader, SoMRCImageRW
 *
 */
class VOLUMEVIZ_API SoVRMrcFileReader : public SoVolumeReader
{

  SO_FIELDCONTAINER_HEADER(SoVRMrcFileReader);
  SO_PIMPL_BASE_PUBLIC_HEADER(SoVRMrcFileReader);

public:

  /** Constructor. */
  SoVRMrcFileReader();

  /**
   * @copydoc SoVolumeReader::setFilename
   */
  virtual int setFilename( const SbString& filename ) override;

  /**
   * @copydoc SoVolumeReader::getDataChar(SbBox3f&,SoDataSet::DataType&,SbVec3i32&)
   */
  virtual ReadError getDataChar( SbBox3f& size, SoDataSet::DataType& type, SbVec3i32& dim ) override;

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,void*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void* data ) override;

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,SoBufferObject*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, SoBufferObject* dataBuffer ) override;

  /**
   * @copydoc SoVolumeReader::getReaderType
   */
  virtual SoVolumeReader::ReaderType getReaderType() override
  {
    return MRC;
  }

  /**
   * Return true as this reader is thread safe.
   */
  virtual SbBool isThreadSafe() const override;

protected:

  /** Destructor. */
  virtual ~SoVRMrcFileReader();
};

