/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : M.Mathiaut (Oct 2014)
**=======================================================================*/

#ifndef  _SO_VR_TIFF_FILE_READER_
#define  _SO_VR_TIFF_FILE_READER_

#include <Inventor/misc/SoRef.h>
#include <Inventor/misc/SoRefCounter.h>
#include <LDM/readers/SoVolumeReader.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <Inventor/STL/vector>
#include <Inventor/SbPImpl.h>


SO_PIMPL_BASE_PUBLIC_DECLARATION(SoVRTiffFileReader);

/**
 * @VREXT TIFF file reader.
 *
 * @ingroup VolumeVizReaders
 *
 * @DESCRIPTION
 *
 * Volume reader for the TIFF file format.
 * VolumeViz automatically selects this reader if a filename is given and the file
 * extension is ".tiff" or ".tif".
 *
 * SoVRTiffFileReader load slices from a single multi-image TIFF file.
 * To load a volume from multiple TIFF files, see the SoVRRasterStackReader class.
 *
 * All the images contained in the file should have the same size.
 * If it is not the case, the reader will find the largest image and take all images
 * with the same size.
 *
 * @B Supported:@b
 * SoVRTiffFileReader is based on libTiff, meaning the reader is able to deal with
 * images which follow the 5.0 or 6.0 TIFF spec (https://libtiff.gitlab.io/libtiff/specification/coverage.html)
 *
 *
 */
class VOLUMEVIZ_API SoVRTiffFileReader : public SoVolumeReader
{

  SO_FIELDCONTAINER_HEADER(SoVRTiffFileReader);
  SO_PIMPL_BASE_PUBLIC_HEADER(SoVRTiffFileReader);

public:

  /** Constructor. */
  SoVRTiffFileReader();

  /**
   * @copydoc SoVolumeReader::setFilename
   */
  virtual int setFilename( const SbString& filename );

  /**
   * @copydoc SoVolumeReader::getDataChar(SbBox3f&,SoDataSet::DataType&,SbVec3i32&)
   */
  virtual ReadError getDataChar( SbBox3f& size, SoDataSet::DataType& type, SbVec3i32& dim ) override;

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,void*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, void* data );

  /**
   * @copydoc SoVolumeReader::getSubSlice(const SbBox2i32&,int,SoBufferObject*)
   */
  virtual void getSubSlice( const SbBox2i32& subSlice, int sliceNumber, SoBufferObject* dataBuffer );

  /**
   * Returns the reader type.
   */
  virtual SoVolumeReader::ReaderType getReaderType()
  {
    return TIFF;
  }

  /**
   * Return true as this reader is thread safe.
   */
  SbBool isThreadSafe() const;

protected:

  /** Destructor. */
  virtual ~SoVRTiffFileReader();
};

#endif /* _SO_VR_TIFF_FILE_READER_ */


