/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Aug 2011)
**=======================================================================*/

#if !defined  _SO_IN_MEMORY_WRITER_H_
#define  _SO_IN_MEMORY_WRITER_H_

#include <LDM/writers/SoVolumeWriter.h>
#include <Inventor/fields/SoSFBufferObject.h>
#include <Inventor/fields/SoSFVec2s.h>

/** 
 * @ingroup VolumeVizWriters
 *
 * @LDMEXT Write data in memory
 *
 * @DESCRIPTION
 *  This writer is the writer corresponding to SoVRMemoryReader. It writes data
 *  in the #data buffer. You can manually specify this buffer. Else, a buffer will
 *  be created in the #initialize() method.
 *  This writer does not organize data on tiles (isDataConverted returns FALSE).
 *  So you must use the #writeSubSlice method and write data slice by slice.
 *  
 *  Do not use the writeTile method with this writer.
 *
 *  SoVRMemoryReader can return an instance of this class already configured
 *  to write into the same area of memory.
 *
 *  Padding can be used to add zeros around the slice to align them in memory:
 *  \verbatim
    ____________________
    |xxxxxxxxxxx|      |
    |xxxxxxxxxxx|      |
    |xxxxxxxxxxx|      |
    |___________|      |
    |                  |
    |__________________|
    <-----------><----->
        slice    padding
    \endverbatim
 *
 * @SEE_ALSO
 *    SoVRMemoryReader
 *    SoVolumeWriter
 *    SoVRLdmFileWriter
*/
class VOLUMEVIZ_API SoVRMemoryWriter : public SoVolumeWriter
{
  SO_FIELDCONTAINER_HEADER( SoVRMemoryWriter );

public:

  /** Buffer containing data. If specified, it must be the right size 
   * (nbVoxel * dataSize, by taking padding in account). If NULL, it will be 
   * allocated in the #initialize() method and deleted in destructor. 
   * default is NULL. */
  SoSFBufferObject data;

  /** Padding over x and y dimension, use to align slice data in memory.
   * default is (0, 0). */
  SoSFVec2s padding;

  /** Constructor */
  SoVRMemoryWriter();

  /** Initialize writer from current parameters. Allocate data buffer */
  virtual SbBool initialize();

  /** Always returns FALSE.  This writer is not organized by tiles. */
  virtual SbBool isDataConverted() const;

  /** @copydoc SoVolumeWriter::writeSubSlice */
  virtual SbBool writeSubSlice( int sliceIndex, const SbBox2i32& subSlice, SoBufferObject* buffer );

protected:

  /** Destructor */
  virtual ~SoVRMemoryWriter();

};

#endif // _SO_IN_MEMORY_WRITER_H_


