/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#if !defined(OIV_DEPTHPEELING_H)
#define OIV_DEPTHPEELING_H

/**
 * @ingroup TransparencyShaders
 * This method peels the current fragment.
 * If the fragment must be ignored, this method does the discard.
 * The fragment coords must be in screen space (gl_FragCoord.xyz should always be used)
 *
 * Returns true if the fragment should be shaded.
 */
bool OivDepthPeel(vec3 fragmentCoords);

/**
 * @ingroup TransparencyShaders
 * When depth peeling is enabled, OivDepthPeelingOutputColor must be
 * called instead of setting 'gl_FragColor' since some depth peeling techniques use
 * MRTs (multiple render targets) or premultiply the color by the alpha value (on-the-fly blending for example).
 */
void OivDepthPeelingOutputColor(vec4 color);

/**
 * @ingroup TransparencyShaders
 * By default the depth generated by the rasterizer (gl_FragCoord.z) is used, but some algorithms may modify the depth
 * in the fragment shader. In these cases gl_FragCoord.z is not valid and the user-defined depth coordinate
 * must be explicitly specified in the 'coords' parameter.
 */
void OivDepthPeelingOutputColor(vec4 color, vec3 coords);

#endif // OIV_DEPTHPEELING_H
