#ifndef OIV_SHAPE_ATTRIBUTE_H
#define OIV_SHAPE_ATTRIBUTE_H

/**
 * @ingroup InventorVertexAttributes
 * @file
 * This file contains fonction to acces vertex attributes.
 */

/*****************************************************************************/
// Attributes

/**
 * Get the position of the current vertex.
 * @return the position of the current vertex.
 */
vec4 OivVertexPosition();

/**
 * Get the normal of the current vertex.
 * @return the normal of the current vertex.
 */
vec3 OivVertexNormal();

/**
 * Get the tangent of the current vertex.
 * @return the tangent of the current vertex.
 */
vec3 OivVertexTangent();

/**
 * Get the color of the current vertex.
 * @return the color of the current vertex.
 */
vec4 OivVertexColor();

/**
 * Get the texture coordinate of the current vertex.
 * @param unit specifies which texture unit between 0 and OivMaxTextureUnit()-1.
 * @return the texture coordinate of the current vertex for a given texture unit.
 */
vec4 OivVertexTextureCoordinate(int unit);

uint OivVertexDrawIndex();

#endif /* OIV_SHAPE_ATTRIBUTE_H */
