/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef VVIZ_GET_DATA_H
#define VVIZ_GET_DATA_H

/**
 * @ingroup VolumeVizShadersData
 * Default voxel value returned by VolumeViz shaders when no data is available.
 */
#ifndef VVIZ_DATARGBA
#define VVizDefaultData VVIZ_DATATYPE(0.0)
#else
#define VVizDefaultData VVIZ_DATATYPE(0,0,0,1)
#endif

/**
 * @ingroup VolumeVizFragmentShaders
 * SoVolumeShader::GET_DATA_FUNCTION function. 
 *
 * Applications can replace this method to customize the SoVolumeShader::GET_DATA_FUNCTION shader stage.
 *
 * NOTE: On the GPU, voxel values are always returned as a normalized value in the
 * range 0..1. If the actual voxel value is needed, the shader function must compute
 * that value using the current data range (see SoDataRange). The application must
 * explicitly pass the current data range to the shader function as a uniform parameter.
 *
 * @param dataset The dataset to read
 * @param dataCoord Uniform data coordinates in volume space.
 * @return voxel data value.
 */
VVIZ_DATATYPE VVizGetData(in VVizDataSetId dataset, in vec3 dataCoord);

/**
 * @ingroup VolumeVizFragmentShaders
 * Default SoVolumeShader::GET_DATA_FUNCTION function. 
 *
 * Method to access dataset, that can be used by VVizGetData custom implementation.
 * It may apply different interpolation (linear, cubix, trilinear, multi-sample12) 
 * depending on SoVolumeRenderingQuality and SoVolumeRender nodes setup.
 *
 * NOTE: On the GPU, voxel values are always returned as a normalized value in the
 * range 0..1. If the actual voxel value is needed, the shader function must compute
 * that value using the current data range (see SoDataRange). The application must
 * explicitly pass the current data range to the shader function as a uniform parameter.
 *
 * @param dataset The dataset to read
 * @param dataCoord uniform data coordinates in volume space.
 * @return voxel data value
 */
VVIZ_DATATYPE VVizGetRawData(in VVizDataSetId dataset, in vec3 dataCoord);

VVIZ_DATATYPE VVizGetData(in VVizDataSetId dataset, in vec3 dataCoord, inout float undefinedFactor);

VVIZ_DATATYPE VVizGetRawData(in VVizDataSetId dataset, in vec3 dataCoord, inout float undefinedFactor);

#endif


