#include <Inventor/ViewerComponents/MFC/RenderArea.h>
#include <Inventor/ViewerComponents/MFC/MFCEventToSoEvent.h>

// static members
SoEventBuilder MFCEventToSoEvent::m_ivEvent;
bool MFCEventToSoEvent::s_init = MFCEventToSoEvent::initClass();

int MFCEventToSoEvent::keyMapInitFlag = 0;
SoKeyboardEvent::Key MFCEventToSoEvent::keyMap[256];

bool MFCEventToSoEvent::m_ctrlModifier = false;
bool MFCEventToSoEvent::m_altModifier = false;
bool MFCEventToSoEvent::m_shiftModifier = false;

bool
MFCEventToSoEvent::initClass()
{
  // initialize virtual key mapping just once
  if ( !keyMapInitFlag )
  {
    keyMapInitFlag = 1;

    int i;
    for ( i = 0; i < 256; i++ )
      keyMap[i] = SoKeyboardEvent::ANY;

    keyMap[VK_SPACE] = SoKeyboardEvent::SPACE;

    // Number keys
    keyMap[0x30] = SoKeyboardEvent::NUMBER_0;
    keyMap[0x31] = SoKeyboardEvent::NUMBER_1;
    keyMap[0x32] = SoKeyboardEvent::NUMBER_2;
    keyMap[0x33] = SoKeyboardEvent::NUMBER_3;
    keyMap[0x34] = SoKeyboardEvent::NUMBER_4;
    keyMap[0x35] = SoKeyboardEvent::NUMBER_5;
    keyMap[0x36] = SoKeyboardEvent::NUMBER_6;
    keyMap[0x37] = SoKeyboardEvent::NUMBER_7;
    keyMap[0x38] = SoKeyboardEvent::NUMBER_8;
    keyMap[0x39] = SoKeyboardEvent::NUMBER_9;

    // Alphabetic keys
    keyMap[0x41] = SoKeyboardEvent::A;
    keyMap[0x42] = SoKeyboardEvent::B;
    keyMap[0x43] = SoKeyboardEvent::C;
    keyMap[0x44] = SoKeyboardEvent::D;
    keyMap[0x45] = SoKeyboardEvent::E;
    keyMap[0x46] = SoKeyboardEvent::F;
    keyMap[0x47] = SoKeyboardEvent::G;
    keyMap[0x48] = SoKeyboardEvent::H;
    keyMap[0x49] = SoKeyboardEvent::I;
    keyMap[0x4A] = SoKeyboardEvent::J;
    keyMap[0x4B] = SoKeyboardEvent::K;
    keyMap[0x4C] = SoKeyboardEvent::L;
    keyMap[0x4D] = SoKeyboardEvent::M;
    keyMap[0x4E] = SoKeyboardEvent::N;
    keyMap[0x4F] = SoKeyboardEvent::O;
    keyMap[0x50] = SoKeyboardEvent::P;
    keyMap[0x51] = SoKeyboardEvent::Q;
    keyMap[0x52] = SoKeyboardEvent::R;
    keyMap[0x53] = SoKeyboardEvent::S;
    keyMap[0x54] = SoKeyboardEvent::T;
    keyMap[0x55] = SoKeyboardEvent::U;
    keyMap[0x56] = SoKeyboardEvent::V;
    keyMap[0x57] = SoKeyboardEvent::W;
    keyMap[0x58] = SoKeyboardEvent::X;
    keyMap[0x59] = SoKeyboardEvent::Y;
    keyMap[0x5A] = SoKeyboardEvent::Z;

    // Numeric pad
    keyMap[VK_NUMPAD0] = SoKeyboardEvent::PAD_0;
    keyMap[VK_NUMPAD1] = SoKeyboardEvent::PAD_1;
    keyMap[VK_NUMPAD2] = SoKeyboardEvent::PAD_2;
    keyMap[VK_NUMPAD3] = SoKeyboardEvent::PAD_3;
    keyMap[VK_NUMPAD4] = SoKeyboardEvent::PAD_4;
    keyMap[VK_NUMPAD5] = SoKeyboardEvent::PAD_5;
    keyMap[VK_NUMPAD6] = SoKeyboardEvent::PAD_6;
    keyMap[VK_NUMPAD7] = SoKeyboardEvent::PAD_7;
    keyMap[VK_NUMPAD8] = SoKeyboardEvent::PAD_8;
    keyMap[VK_NUMPAD9] = SoKeyboardEvent::PAD_9;

    keyMap[VK_MULTIPLY] = SoKeyboardEvent::PAD_MULTIPLY;
    keyMap[VK_ADD] = SoKeyboardEvent::PAD_ADD;
    keyMap[VK_SUBTRACT] = SoKeyboardEvent::PAD_SUBTRACT;
    keyMap[VK_DIVIDE] = SoKeyboardEvent::PAD_DIVIDE;
    keyMap[VK_OEM_PLUS] = SoKeyboardEvent::EQUAL;
    keyMap[VK_OEM_COMMA] = SoKeyboardEvent::COMMA;
    keyMap[VK_OEM_MINUS] = SoKeyboardEvent::MINUS;
    keyMap[VK_OEM_PERIOD] = SoKeyboardEvent::PERIOD;

    // Function keys
    keyMap[VK_F1] = SoKeyboardEvent::F1;
    keyMap[VK_F2] = SoKeyboardEvent::F2;
    keyMap[VK_F3] = SoKeyboardEvent::F3;
    keyMap[VK_F4] = SoKeyboardEvent::F4;
    keyMap[VK_F5] = SoKeyboardEvent::F5;
    keyMap[VK_F6] = SoKeyboardEvent::F6;
    keyMap[VK_F7] = SoKeyboardEvent::F7;
    keyMap[VK_F8] = SoKeyboardEvent::F8;
    keyMap[VK_F9] = SoKeyboardEvent::F9;
    keyMap[VK_F10] = SoKeyboardEvent::F10;
    keyMap[VK_F11] = SoKeyboardEvent::F11;
    keyMap[VK_F12] = SoKeyboardEvent::F12;

    keyMap[VK_BACK] = SoKeyboardEvent::BACKSPACE;
    keyMap[VK_TAB] = SoKeyboardEvent::TAB;
    keyMap[VK_RETURN] = SoKeyboardEvent::RETURN;
    keyMap[VK_SHIFT] = SoKeyboardEvent::LEFT_SHIFT;
    keyMap[VK_CONTROL] = SoKeyboardEvent::LEFT_CONTROL;
    keyMap[VK_MENU] = SoKeyboardEvent::LEFT_ALT;
    keyMap[VK_PAUSE] = SoKeyboardEvent::PAUSE;
    keyMap[VK_CAPITAL] = SoKeyboardEvent::CAPS_LOCK;
    keyMap[VK_ESCAPE] = SoKeyboardEvent::ESCAPE;
    keyMap[VK_PRIOR] = SoKeyboardEvent::PAGE_UP;
    keyMap[VK_NEXT] = SoKeyboardEvent::PAGE_DOWN;
    keyMap[VK_END] = SoKeyboardEvent::END;
    keyMap[VK_HOME] = SoKeyboardEvent::HOME;
    keyMap[VK_LEFT] = SoKeyboardEvent::LEFT_ARROW;
    keyMap[VK_UP] = SoKeyboardEvent::UP_ARROW;
    keyMap[VK_RIGHT] = SoKeyboardEvent::RIGHT_ARROW;
    keyMap[VK_DOWN] = SoKeyboardEvent::DOWN_ARROW;
    keyMap[VK_PRINT] = SoKeyboardEvent::PRINT;
    keyMap[VK_INSERT] = SoKeyboardEvent::INSERT;
    keyMap[VK_DELETE] = SoKeyboardEvent::KEY_DELETE;
    keyMap[VK_NUMLOCK] = SoKeyboardEvent::NUM_LOCK;
    keyMap[VK_SCROLL] = SoKeyboardEvent::SCROLL_LOCK;
    keyMap[VK_LWIN] = SoKeyboardEvent::LEFT_META;
  }
  return true;
}

SoKeyboardEvent::Key
MFCEventToSoEvent::getIvKey( WPARAM param )
{
  return keyMap[param];
}

SoMouseButtonEvent*
MFCEventToSoEvent::getMousePressEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea)
{
  return m_ivEvent.getMousePressEvent( loc.x, ( renderArea->getHeight() - 1 ) - loc.y, button, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoMouseButtonEvent*
MFCEventToSoEvent::getMouseReleaseEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea)
{
  return m_ivEvent.getMouseReleaseEvent( loc.x, ( renderArea->getHeight() - 1 ) - loc.y, button, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoMouseButtonEvent*
MFCEventToSoEvent::getMouseDoubleClickEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea)
{
  return m_ivEvent.getMouseDoubleClickEvent( loc.x, ( renderArea->getHeight() - 1 ) - loc.y, button, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoLocation2Event*
MFCEventToSoEvent::getMouseMoveEvent( CPoint loc, RenderArea* renderArea)
{
  return m_ivEvent.getMouseMoveEvent( loc.x, ( renderArea->getHeight() - 1 ) - loc.y, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoMouseWheelEvent*
MFCEventToSoEvent::getMouseWheelEvent( short zDelta, RenderArea* )
{
  return m_ivEvent.getMouseWheelEvent( zDelta, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoLocation2Event*
MFCEventToSoEvent::getMouseEnterEvent( RenderArea* )
{
  return m_ivEvent.getMouseEnterEvent( 0, 0, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoLocation2Event*
MFCEventToSoEvent::getMouseLeaveEvent( RenderArea* )
{
  return m_ivEvent.getMouseLeaveEvent( 0, 0, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoKeyboardEvent*
MFCEventToSoEvent::getKeyPressEvent( WPARAM param, RenderArea* )
{
  SoKeyboardEvent::Key ivKey = getIvKey( param );

  switch ( ivKey )
  {
  case SoKeyboardEvent::LEFT_CONTROL:
    m_ctrlModifier = true;
    break;
  case SoKeyboardEvent::LEFT_ALT:
    m_altModifier = true;
    break;
  case SoKeyboardEvent::LEFT_SHIFT:
    m_shiftModifier = true;
    break;
  }

  return m_ivEvent.getKeyPressEvent( ivKey, m_altModifier, m_ctrlModifier, m_shiftModifier );
}

SoKeyboardEvent*
MFCEventToSoEvent::getKeyReleaseEvent( WPARAM param, RenderArea* )
{
  SoKeyboardEvent::Key ivKey = getIvKey( param );

  switch ( ivKey )
  {
  case SoKeyboardEvent::LEFT_CONTROL:
    m_ctrlModifier = false;
    break;
  case SoKeyboardEvent::LEFT_ALT:
    m_altModifier = false;
    break;
  case SoKeyboardEvent::LEFT_SHIFT:
    m_shiftModifier = false;
    break;
  }

  return m_ivEvent.getKeyReleaseEvent( ivKey, m_altModifier, m_ctrlModifier, m_shiftModifier );
}
