#include <Inventor/ViewerComponents/MFC/Viewers/ViewerExaminer.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/ViewerComponents/SoCameraInteractor.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

#include "StereoPropertiesDialog.h"
#include "res/resource.h"

BEGIN_MESSAGE_MAP(ViewerExaminer, CFrameWnd)
  ON_WM_CREATE()
  ON_WM_SETFOCUS()
  ON_WM_MOUSEWHEEL()
END_MESSAGE_MAP()

/*
// diagnostic routine to check for and decode dialog templates
// return FALSE if a program error occurs (i.e. bad resource ID or
//   bad dialog styles).
BOOL  ViewerExaminer::_AfxCheckDialogTemplate(LPCTSTR lpszResource, BOOL bInvisibleChild)
{
  ASSERT(lpszResource != NULL);
  HINSTANCE hInst = AfxFindResourceHandle(lpszResource, RT_DIALOG);
  HRSRC hResource = ::FindResource(hInst, lpszResource, RT_DIALOG);
  if (hResource == NULL)
  {
    if (DWORD_PTR(lpszResource) > 0xffff)
      TRACE(traceAppMsg, 0, _T("ERROR: Cannot find dialog template named '%s'.\n"),
      lpszResource);
    else
      TRACE(traceAppMsg, 0, "ERROR: Cannot find dialog template with IDD 0x%04X.\n",
      LOWORD((DWORD_PTR)lpszResource));
    return FALSE;
  }

  if (!bInvisibleChild)
    return TRUE;        // that's all we need to check

  // we must check that the dialog template is for an invisible child
  //  window that can be used for a form-view or dialog-bar
  HGLOBAL hTemplate = LoadResource(hInst, hResource);
  if (hTemplate == NULL)
  {
    TRACE(traceAppMsg, 0, "Warning: LoadResource failed for dialog template.\n");
    // this is only a warning, the real call to CreateDialog will fail
    return TRUE;        // not a program error - just out of memory
  }
  DLGTEMPLATEEX* pTemplate = (DLGTEMPLATEEX*)LockResource(hTemplate);
  DWORD dwStyle;
  if (pTemplate->signature == 0xFFFF)
    dwStyle = pTemplate->style;
  else
    dwStyle = ((DLGTEMPLATE*)pTemplate)->style;
  UnlockResource(hTemplate);
  FreeResource(hTemplate);

  if (dwStyle & WS_VISIBLE)
  {
    if (DWORD_PTR(lpszResource) > 0xffff)
      TRACE(traceAppMsg, 0, _T("ERROR: Dialog named '%s' must be invisible.\n"),
      lpszResource);
    else
      TRACE(traceAppMsg, 0, "ERROR: Dialog with IDD 0x%04X must be invisible.\n",
      LOWORD((DWORD_PTR)lpszResource));
    return FALSE;
  }
  if (!(dwStyle & WS_CHILD))
  {
    if (DWORD_PTR(lpszResource) > 0xffff)
      TRACE(traceAppMsg, 0, _T("ERROR: Dialog named '%s' must have the child style.\n"),
      lpszResource);
    else
      TRACE(traceAppMsg, 0, "ERROR: Dialog with IDD 0x%04X must have the child style.\n",
      LOWORD((DWORD_PTR)lpszResource));
    return FALSE;
  }

  return TRUE;
}

*/

//------------------------------------------------------------------------------
ViewerExaminer::ViewerExaminer()
  : CFrameWnd()
  , m_stereoDialog(NULL)
{
}

//------------------------------------------------------------------------------
ViewerExaminer::~ViewerExaminer()
{
  delete m_stereoDialog;
  m_stereoDialog = NULL;
}

//------------------------------------------------------------------------------
int ViewerExaminer::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
  if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
    return -1;

  if (!m_renderAreaExaminer.Create( NULL, NULL, AFX_WS_DEFAULT_VIEW, CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL ))
    return -1;
 
  m_stereoDialog = new StereoPropertiesDialog;
  if (!m_stereoDialog->Create( IDD_STEREODIALOG, &m_renderAreaExaminer ))
    return -1;

  m_renderAreaExaminer.initializeGL( GetDC()->m_hDC, true );

  if (!isRawStereoAvailable())
    MessageBox( _T("Could not enable stereo buffers."), _T("Warning"), MB_ICONWARNING | MB_OK );

  return 0;
}

//------------------------------------------------------------------------------
BOOL ViewerExaminer::PreCreateWindow( CREATESTRUCT& cs )
{
  if (!CFrameWnd::PreCreateWindow( cs ))
    return FALSE;

  cs.cx = 950;
  cs.cy = 650;

  cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
  cs.lpszClass = AfxRegisterWndClass( 0 );
  return TRUE;
}

//------------------------------------------------------------------------------
void
ViewerExaminer::loadFile( const SbString& filename )
{
  SoInput input;

  // We try to open the file
  if (input.openFile( filename ))
  {
    // We read the content.
    m_sceneGraph = SoDB::readAll( &input );
    m_renderAreaExaminer.setSceneGraph( m_sceneGraph.ptr() );
    m_renderAreaExaminer.viewAll( SbViewportRegion() );
  }
}

//------------------------------------------------------------------------------
void
ViewerExaminer::viewAll()
{
  m_renderAreaExaminer.viewAll( SbViewportRegion() );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::setNavigationMode( SceneExaminer::NavigationMode mode )
{
  m_renderAreaExaminer.setNavigationMode( mode );
}

//------------------------------------------------------------------------------
SceneExaminer::NavigationMode
ViewerExaminer::getNavigationMode()
{
  return m_renderAreaExaminer.getNavigationMode();
}

//------------------------------------------------------------------------------
RenderAreaInteractive::ClippingPlanesAdjustMode
ViewerExaminer::getClippingPlanesAdjustMode()
{
  return m_renderAreaExaminer.getClippingPlanesAdjustMode();
}

//------------------------------------------------------------------------------
void
ViewerExaminer::setClippingPlanesAdjustMode( RenderAreaInteractive::ClippingPlanesAdjustMode mode )
{
  m_renderAreaExaminer.setClippingPlanesAdjustMode( mode );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::viewAxis( const SbVec3f& direction, const SbVec3f& up )
{
  m_renderAreaExaminer.viewAxis( direction, up );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::saveCamera()
{
  m_renderAreaExaminer.getSceneInteractor()->getCameraInteractor()->pushCamera();
}

//------------------------------------------------------------------------------
void
ViewerExaminer::restoreCamera()
{
  m_renderAreaExaminer.getSceneInteractor()->getCameraInteractor()->popCamera();
}

//------------------------------------------------------------------------------
BOOL
ViewerExaminer::OnMouseWheel( UINT flags, short zDelta, CPoint pt )
{
  // We need this code because the child CWnd (m_renderAreaExaminer) can't catch wheel event
  return m_renderAreaExaminer.OnMouseWheel(flags, zDelta, pt);
}

//------------------------------------------------------------------------------
BOOL
ViewerExaminer::PreTranslateMessage( MSG* pMsg )
{
  return m_renderAreaExaminer.PreTranslateMessage( pMsg );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::setSeekMode( bool onOrOff )
{
  m_renderAreaExaminer.getSceneInteractor()->setSeekMode( onOrOff );
}

void
ViewerExaminer::openStereoPreferences()
{
  if ( !m_renderAreaExaminer.isStereoSupported() || !m_renderAreaExaminer.isRawStereoAvailable() )
  {
    // disable stereo controls if stereo is not supported
    m_stereoDialog->enableControls( false );
  }
  m_stereoDialog->ShowWindow( SW_SHOW );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::activateStereo( bool activated )
{
  m_renderAreaExaminer.activateStereo( activated );
}

//------------------------------------------------------------------------------
bool
ViewerExaminer::isRawStereoAvailable()
{
  return m_renderAreaExaminer.isRawStereoAvailable();
}

//------------------------------------------------------------------------------
bool
ViewerExaminer::isStereoSupported()
{
  return m_renderAreaExaminer.isStereoSupported();
}

//------------------------------------------------------------------------------
void
ViewerExaminer::setStereoCameraOffset( float offset )
{
  m_renderAreaExaminer.setStereoCameraOffset( offset );
}

//------------------------------------------------------------------------------
void
ViewerExaminer::setStereoCameraBalance( float balance )
{
  m_renderAreaExaminer.setStereoCameraBalance( balance );
}
