#include <Inventor/ViewerComponents/Qt/QML/RenderAreaOrbiter.h>

using namespace openinventor::inventor::viewercomponents::qt::qml;

//------------------------------------------------------------------------------
RenderAreaOrbiter::RenderAreaOrbiter()
  : RenderAreaInteractive( false )
{
  m_rootSceneGraph = m_sceneOrbiter = new SceneOrbiter();
  buildSceneGraph();
}

//------------------------------------------------------------------------------
SceneOrbiter*
RenderAreaOrbiter::getSceneInteractor() const
{
  return m_sceneOrbiter;
}

//------------------------------------------------------------------------------
void
RenderAreaOrbiter::createRenderAreaCore( SbVec2i32 region )
{
  RenderAreaInteractive::createRenderAreaCore( region );

  // Deactivate auto interactive mode,
  // interactive mode is managed by the SceneOrbiter.
  m_renderAreaCore->getSceneManager()->setAutoInteractiveMode( false );
}
