#include <Inventor/ViewerComponents/Qt/RenderAreaExaminer.h>
#include <qpixmap.h>


QCursor* RenderAreaExaminer::s_seekCursor = NULL;
QCursor* RenderAreaExaminer::s_viewingCursor = NULL;

//------------------------------------------------------------------------------
RenderAreaExaminer::RenderAreaExaminer( QWidget* parent )
  : RenderAreaInteractive( parent, false )
{
  // QPixmap need QApplication
  if ( RenderAreaExaminer::s_seekCursor == NULL )
  {
    RenderAreaExaminer::s_seekCursor = new QCursor(QPixmap(QLatin1String(":icons/CursorSeek.png"), "png", Qt::MonoOnly));
  }

  if ( RenderAreaExaminer::s_viewingCursor == NULL )
  {
    RenderAreaExaminer::s_viewingCursor = new QCursor(QPixmap(QLatin1String(":icons/CursorCurvedHand.png"), "png", Qt::MonoOnly));
  }

  // Disable SceneExaminer automatic adjustment of clipping planes,
  // adjustment is managed by the render area.
  SoPreferences::setBool("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", false);
  // Deactivate auto interactive mode,
  // interactive mode is managed by the SceneExaminer.
  m_isAutoInteractive = false;

  m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();
  // Listening interaction from the scene examiner
  m_examinerRootSceneGraph->addInteractionModeListener(this);
  // Init cursor shape
  updateInteractionCursor();

  buildSceneGraph();
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneExaminer()
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneInteractor() const
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::setNavigationMode( SceneExaminer::NavigationMode mode )
{
  m_examinerRootSceneGraph->setNavigationMode( mode );
  updateInteractionCursor();
}

//------------------------------------------------------------------------------
SceneExaminer::NavigationMode
RenderAreaExaminer::getNavigationMode()
{
  return m_examinerRootSceneGraph->getNavigationMode();
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::seekModeChanged( const bool seek )
{
  if ( seek )
  {
    setCursor( *RenderAreaExaminer::s_seekCursor );
  }
  else
  {
    updateInteractionCursor();
  }
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::interactionModeChanged( SceneExaminer::InteractionMode /*mode*/ )
{
  updateInteractionCursor();
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::updateInteractionCursor()
{
  if ( ( ( SceneExaminer* )getSceneInteractor() )->getInteractionMode() == SceneExaminer::NAVIGATION )
  {
    setCursor( *RenderAreaExaminer::s_viewingCursor );
  }
  else
  {
    setCursor( Qt::ArrowCursor );
  }
}