#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

#include <QDialog>

#include "ui_PreferencesDialog.h"

class ViewerExaminer;

/**
 * This class adds the events support to the interface of the preferences
 * dialog designed using Qt designer.
 */
class PreferencesDialog : public QDialog, public Ui::Dialog
{
  Q_OBJECT

public:

  static PreferencesDialog* getInstance( ViewerExaminer* viewerExaminer );

  void enableStereoPreferences( bool enabled );

protected Q_SLOTS:

  // Navigation mode
  void navigationModeChanged( int mode, bool checked );
  // Clipping mode
  void clippingModeChanged( int index );

  /**
   * Raw stereo activation.
   */
  void activateRawStereo( bool activated );

  void balanceValueChanged( int value );
  void slot_check_balance( bool checked );

  void offsetValueChanged( int value );
  void slot_check_offset( bool checked );

private:

  /**
   * Constructor.
   */
  PreferencesDialog( ViewerExaminer* viewerExaminer );

  static PreferencesDialog* m_instance;

  ViewerExaminer* m_viewerExaminer;

};

#endif // PREFERENCES_DIALOG_H


