#include <Inventor/ViewerComponents/Win/RenderAreaExaminer.h>

#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

HCURSOR RenderAreaExaminer::s_seekCursor = LoadCursor(NULL, IDC_CROSS);
HCURSOR RenderAreaExaminer::s_viewingCursor = LoadCursor(NULL, IDC_HAND);
HCURSOR RenderAreaExaminer::s_selectionCursor = LoadCursor(NULL, IDC_ARROW);

//------------------------------------------------------------------------------
RenderAreaExaminer::RenderAreaExaminer()
  : RenderAreaInteractive(false)
{
  // Disable SceneExaminer automatic adjustment of clipping planes,
  // adjustment is managed by the render area.
  SoPreferences::setBool("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", false);
  m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();
  // Deactivate auto interactive mode,
  // interactive mode is managed by the SceneExaminer.
  m_isAutoInteractive = false;

  // Listening interactions from the scene examiner
  m_examinerRootSceneGraph->addInteractionModeListener(this);

  // Init cursor shape
  updateInteractionCursor();

  buildSceneGraph();
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneExaminer()
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
SceneExaminer*
RenderAreaExaminer::getSceneInteractor() const
{
  return m_examinerRootSceneGraph;
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::processEvents(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  switch ( uMsg )
  {
    case WM_SETCURSOR:
    {
      SetCursor(s_currentCursor);
      break;
    }
  }

  RenderAreaInteractive::processEvents(uMsg, wParam, lParam);
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::seekModeChanged(const bool seek)
{
  if ( seek )
  {
    s_currentCursor = s_seekCursor;
    SetCursor(s_currentCursor);
  }
  else
  {
    updateInteractionCursor();
  }
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::interactionModeChanged(SceneExaminer::InteractionMode mode)
{
  updateInteractionCursor();
}

//------------------------------------------------------------------------------
void
RenderAreaExaminer::updateInteractionCursor()
{
  if ( ( ( SceneExaminer* )getSceneInteractor() )->getInteractionMode() == SceneExaminer::NAVIGATION )
  {
    s_currentCursor = s_viewingCursor;
  }
  else
  {
    s_currentCursor = s_selectionCursor;
  }
  SetCursor(s_currentCursor);
}
