/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Created by : David Beilloin (Mar 2014)
**=======================================================================*/

#ifndef  _SO_INPUT_GENERIC_FILE_READER_H_
#define  _SO_INPUT_GENERIC_FILE_READER_H_

#include <Inventor/SoInputReader.h>

// IvGenericFileReader_EXPORTS is defined only when building IvStlReader dll
#ifdef IvGenericFileReader_EXPORTS
#  define IVGENERICREADER_API VC_DLL_EXPORT
#else
#  define IVGENERICREADER_API VC_DLL_IMPORT
#endif

extern "C" IVGENERICREADER_API void initPlugin();
extern "C" IVGENERICREADER_API void exitPlugin();

/**
 * This reader plugin generate a generic scenegraph to render
 * the given file extension.
 *
 * Currently it support:
 * - VolumeViz reader file format.
 * - Open Inventor 2D rasterImage image file format.
 */
class SoInputGenericReader : public SoInputReader
{
  SO_TYPED_CLASS_HEADER();

public:
  /** Default constructor */
  SoInputGenericReader();
  /** Destructor */
  virtual ~SoInputGenericReader();

  /**
   * @copydoc SoInputReader::canConvert
   * returns TRUE for VolumeViz reader file format and Open Inventor RasterImage file format supported
   */
  virtual bool canConvert(SoInput*);
  
  /**
   * @copydoc SoInputReader::convert
   * returns a typical rendering scene graph for the given file.
   */
  virtual SoSeparator* convert(SoInput*);
};

#endif // _SO_INPUT_GENERIC_FILE_READER_H_
