/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_DIRECTIONAL_LIGHT_EDITOR_H
#define IVT_DIRECTIONAL_LIGHT_EDITOR_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_DirectionalLightEditor
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtEditor.h>

#include <Inventor/devices/SoGLFormat.h>
#include <Inventor/devices/SoGLContext.h>

#include <Inventor/events/SoButtonEvent.h>

#include <ui_Ivt_DirectionalLightEditor_UI.h>

#include <QColor>

class QColorDialog;
class QDockWidget;
class QFrame;
class QOpenGLWidget;
class QMouseEvent;

class SoCallbackList;
class SoCamera;
class SoDirectionalLight;
class SoDirectionalLightManip;
class SoDragger;
class SoEvent;
class SoGuiAlgoViewers;
class SoLocation2Event;
class SoMouseButtonEvent;
class SoNode;
class SoNodeSensor;
class SoPerspectiveCamera;
class SoSceneManager;
class SoSensor;
class SoSeparator;

/** 
 * @VSGEXT IvTune editor for directional lights.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class provides an editor with a render area representing 
 * a directional light and allows the user to edit the direction  
 * of the light, its intensity and its color.
 *
 */

class Ivt_DirectionalLightEditor : public IvtEditor, Ui::directionalLightEditor
{
  Q_OBJECT

public:
  /**
   * Constructor.
   */
  Ivt_DirectionalLightEditor();

  /**
   * Destructor.
   */
  virtual ~Ivt_DirectionalLightEditor();

  // Methods redifined from IvtExtension, IvtEditor and IvtNodeEditor
  /**
   * Activates this extension.
   */
  virtual void activate();

  /**
   * Deactivates this extension.
   */
  virtual void deactivate();

  /**
   * Hides this editor.
   */
  virtual void hide();



  /**
   * Loads this extension.
   */
  virtual void load();



  /**
   * Shows this editor.
   */
  virtual void show();

  /**
   * Unloads this extension.
   */
  virtual void unload();

public Q_SLOTS:
  /**
   * Opens the color editor.
   */
  virtual void openColorEditor();

  /**
   * Callback for the intensity slider.
   */
  virtual void intensitySliderCB( int value );

protected:
  /** 
   * Filters events for the gl render area and the color editor 
   */
  virtual bool eventFilter( QObject* watched, QEvent* event );

  /**
   * Updates the render area.
   */
  virtual void updateRA();

  /**
   * Converts a Qt mouse event into an SoEvent,
   * returning NULL if the event is not from this device.
   */
  virtual const SoEvent* translateEvent( QMouseEvent* event );
    
protected Q_SLOTS:
  /**
   * Callback for the line editor of the intensity slider.
   */
  virtual void intensityLECB();

private:
  /** Init the GL render area. */
  void initGL();

  /** Copies src directional light. */
  void copyLight( SoDirectionalLight* dst, const SoDirectionalLight* src );

  /** Sets up this editor. */
  void setUp();

  /** Methods for event translation. */
  SoLocation2Event* translateMotionEvent( QMouseEvent* me );
  SoMouseButtonEvent* translateButtonEvent( QMouseEvent* be, SoButtonEvent::State s );

    /** Updates slider and colors. */
  void updateLocalComponents();

  /** Editor's callbacks */
  static void cameraSensorCB( Ivt_DirectionalLightEditor* editor, SoSensor* sensor );
  static void dirLightManipCB( void* data, SoDragger* dragger );
  static void editorRenderCB( void* data, SoSceneManager* mgr );

  /** Scene displayed in the editor. */
  static char* m_editorContentBuffer;

  /** GL render area algorithms. */
  SoGuiAlgoViewers* m_glRAAlgos;

  /** Editor scenegraph elements. */
  SbBool m_ignoreCallback; // TRUE while callback should be ignored
  SoCallbackList* m_callbackList;
  SoCamera* m_cameraToWatch;
  SoDirectionalLightManip* m_dirLightManip;
  SoDirectionalLight* m_dirLight;              // Light we are editing
  SoLocation2Event* m_loc2Event;
  SoMouseButtonEvent* m_buttonEvent;
  SoNodeSensor* m_cameraSensor;
  SoSeparator* m_root;                  // Root of local scene graph
  SoSeparator* m_litStuff;            // What's on display under the light
  SoPerspectiveCamera* m_editorCamera;  

  /** GL render area rendering context. */
  SoRef<SoGLContext> m_oglContext;

  /** Pointer to the user scene graph. */
  SoNode* m_usg;

  /** Color editor. */
#if (QT_VERSION < 0x040500)
#else
  QColorDialog* m_colorDialog;
#endif

  /** GL render aera. */
  QOpenGLWidget* m_glRA;

  /** Containers for this editor. */

  QFrame* m_container;

private Q_SLOTS:
  /** QColorDialog selection callback. */
  void colorDialogCB( const QColor& currentColor );
};

#endif // IVT_DIRECTIONAL_LIGHT_EDITOR_H


