/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_PROCESSING_MENU_H
#define IVT_PROCESSING_MENU_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_ProcessingMenu
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtExtension.h>

#include <QtCore/QObject>

/** 
 * @VSGEXT IvTune class for LargeModelViewer processing menu.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class adds the processing menu of the LargeModelViewer in the treeview
 * context menu.
 *
 */

class IvtShell;
class Ivt_ProcessingMenu;
class Ivt_ProcessingMenuActionsManager;

class QAction;
class QMenu;

class SoGuiAlgoViewers;
class SoFieldContainer;
class SoNode;

class Ivt_ProcessingMenu : public IvtExtension
{
  Q_OBJECT

public:
  /**
   * Constructor.
   */
  Ivt_ProcessingMenu();

  /**
   * Destructor.
   */
  ~Ivt_ProcessingMenu();

  // Methods redifined from IvtExtension
  /**
   * Activates this extension.
   */
  virtual void activate();

  /**
   * Deactivates this extension.
   */
  virtual void deactivate();

  /**
   * Hides this extension.
   */
  virtual void hide();

  /**
   * Registers this extension.
   */
  virtual void load();

  /**
   * Shows this extension.
   */
  virtual void show();

  /**
   * Unregisters this extension.
   */
  virtual void unload();

public Q_SLOTS:
  // Processing menu slots
  /**
   * Reorganizes the scene using triangle strips.
   */
  virtual void pmReorganizeProcess();

  /**
   * Simplifies the shapes in the scene.
   */
  virtual void pmShapeSimplifyProcess();

  /**
   * Simplifies the whole scene.
   */
  virtual void pmGlobalSimplifyProcess();

  /**
   * Simplifies the shapes in the scene using triangle strips.
   */
  virtual void pmShapeSimplifyTSProcess();

  /**
   * Simplifies the whole scene using triangle strips.
   */
  virtual void pmGlobalSimplifyTSProcess();

  /**
   * Opens a dialog to tune the split action applied to the shapes of the scene.
   */
  virtual void pmSplitShapesProcess();

  /**
   * Resets the processing menu if a new node is about to be processed
   */
  virtual void pmCheckNode( SoFieldContainer* node );

private:
  /** Builds the processing menu and add it to the treeview contextual menu. */
  void buildProcessingMenu();
  /** If the user clicks on a new node, the processing menu must be reseted
    * in order to re-enable previously disbaled functions */
  void processingMenuReset();


  /** Processing menu */
  QMenu* m_processingMenu;
  QAction* m_loadInlinesItem;
  QAction* m_reorganizeItem;
  QAction* m_shapeSimplifyItem;
  QAction* m_globalSimplifyItem;
  QAction* m_shapeSimplifyTSItem;
  QAction* m_globalSimplifyTSItem;
  QAction* m_splitShapeItem;
  SoNode* m_currentProcessedNode;

  /** Processing menu action manager */
  Ivt_ProcessingMenuActionsManager* m_acma;
};

#endif // IVT_PROCESSING_MENU_H


