/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan MEHAMLI (Dec 2010)
**=======================================================================*/

#include <Ivt_ProcessingMenuActionsManager.h>
#include <Ivt_PMSplitDialog.h>

#include <Inventor/actions/SoGlobalSimplifyAction.h>
#include <Inventor/actions/SoReorganizeAction.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/actions/SoShapeSimplifyAction.h>

#include <Inventor/simplifier/SoDecimator.h>

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoSeparator.h>

//------------------------------------------------------------------------------
Ivt_ProcessingMenuActionsManager::Ivt_ProcessingMenuActionsManager()
{

}

//------------------------------------------------------------------------------
Ivt_ProcessingMenuActionsManager::~Ivt_ProcessingMenuActionsManager()
{

}

//------------------------------------------------------------------------------
// Processing actions
//------------------------------------------------------------------------------
bool
Ivt_ProcessingMenuActionsManager::reorganizeProcess( SoNode* node )
{
  bool result = false;

  // Organize scene under new separator:
  SoSeparator* sep = new SoSeparator;
  SoGroup* tmpNode = (SoGroup*)node;
  sep->ref();
  for ( int i=0; i<tmpNode->getNumChildren(); i++ )
    sep->addChild( tmpNode->getChild(i) );
  
  // Do the action
  SoReorganizeAction* simplify = new SoReorganizeAction; ;
  simplify->generateNormals( TRUE );
  simplify->generateTriangleStrips( TRUE );
  simplify->apply( sep );
  sep->unref();

  // Use the simplified scene graph
  if ( simplify->getSimplifiedSceneGraph() != NULL )
  {
    SoSeparator* simplifiedSG = simplify->getSimplifiedSceneGraph();
    tmpNode->removeAllChildren ();
    tmpNode->addChild( simplifiedSG );
        
    result = true;
  }

  delete simplify;

  return result;
}

//------------------------------------------------------------------------------
void
Ivt_ProcessingMenuActionsManager::shapeSimplifyProcess( SoNode* node, bool doTS )
{
  // Starting the job
  int numLevels = 3;
  static float levels[5] = {1.0f, 0.3f, 0.1f};

  // The Simplifier object: uses geometric simplification
  SoDecimator *decimer = new SoDecimator;
  SoShapeSimplifyAction simplify( decimer );
  simplify.setSimplificationLevels( numLevels, levels );
  simplify.setSizeFactor( 4. );
  simplify.setMinTriangles( 20 );
  simplify.apply( node );
  delete decimer;
  
  // Do triangle stripping on results:
  if ( doTS ) 
    reorganizeSimplified( node );
}

//------------------------------------------------------------------------------
bool
Ivt_ProcessingMenuActionsManager::globalSimplifyProcess( SoNode* node, bool doTS )
{
  bool result = false;

  // Replace scene with reorganized scene graph:
  int numLevels = 3;
  static float levels[5] = {1.0f, 0.3f, 0.1f};
  
  SoDecimator* decimer = new SoDecimator;
  SoGlobalSimplifyAction *simplify = new SoGlobalSimplifyAction( decimer );
  simplify->setSimplificationLevels( numLevels, levels );
  simplify->setSizeFactor( 4. );
  simplify->setMinTriangles( 20 );
  simplify->setVerbosity( TRUE );
  simplify->setSimplificationStrategy( SoGlobalSimplifyAction::SIMPLIFY_GLOBALLY );
  
  // Organize scene under new separator:
  SoSeparator* sep = new SoSeparator;
  sep->ref();
  SoGroup* tmpNode = (SoGroup*)node;
  for ( int i=0; i<tmpNode->getNumChildren(); i++ )
    sep->addChild( tmpNode->getChild(i) );
  simplify->apply( sep );
  sep->unref();
  
  if ( simplify->getSimplifiedSceneGraph() != NULL )
  {
    SoSeparator* simplifiedSG = simplify->getSimplifiedSceneGraph();
    tmpNode->removeAllChildren();
    tmpNode->addChild( simplifiedSG );
    
    if ( doTS )
      reorganizeSimplified( simplifiedSG );

    result = true;
  }
  
  delete simplify;
  delete decimer;

  return result;
}

//------------------------------------------------------------------------------
void
Ivt_ProcessingMenuActionsManager::reorganizeSimplified( SoNode* graph )
{
  graph->ref();
  
  SoSearchAction search;
  search.setType( SoLevelOfSimplification::getClassTypeId() );
  search.setInterest( SoSearchAction::ALL );
  search.apply( graph );
  
  SoNodeList alreadyDone;
  
  SoPathList paths = search.getPaths();
  for ( int i=0; i<paths.getLength(); i++ ) 
  {
    SoFullPath* fullpath = (SoFullPath*)paths[i];
    SoLevelOfSimplification* los = (SoLevelOfSimplification*)fullpath->getTail();
    for ( int c=0; c<los->getNumChildren(); c++ ) 
    {
      SoNode* node = los->getChild( c );
      
      if ( alreadyDone.find(node) >=0 ) 
      {
        // We have already tri-stripped this node,
        // so skip it now:
        continue;
      }
      alreadyDone.append( node );
      
      SoReorganizeAction tristripper;
      tristripper.generateNormals( TRUE );
      tristripper.generateTriangleStrips( TRUE );
      tristripper.apply( node );
      if ( tristripper.getSimplifiedSceneGraph() != NULL ) 
      {
        SoNode* result = tristripper.getSimplifiedSceneGraph();
        if ( result != node )
          los->replaceChild( node, result );
      }
    }
  }
  
  graph->unrefNoDelete();
}

//------------------------------------------------------------------------------
void
Ivt_ProcessingMenuActionsManager::splitShapesProcess( SoNode* node )
{
  Ivt_PMSplitDialog* dlg = new Ivt_PMSplitDialog( NULL, (SoGroup*)node );
  dlg->exec ();
}


