/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_SHADER_EDITOR_H
#define IVT_SHADER_EDITOR_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_ShaderEditor
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtEditor.h>

#include <ui_Ivt_ShaderEditor_UI.h>

#include <QtCore/QString>

/** 
 * @VSGEXT IvTune editor for shader programs.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class provides an editor with syntax highlighting for
 * GLSL shader programs and basic text editing commands.
 *
 */

class Ivt_ShaderSyntaxHighlight;

class SoShaderObject;

class QDockWidget;
class QFrame;

class Ivt_ShaderEditor : public IvtEditor, Ui::shaderEditor
{
  Q_OBJECT
public:
  /**
   * Constructor.
   */
  Ivt_ShaderEditor();

  /**
   * Destructor.
   */
  virtual ~Ivt_ShaderEditor();

  // Methods redifined from IvtExtension, IvtEditor and IvtNodeEditor
  /**
   * Activates this extension.
   */
  virtual void activate();

  /**
   * Deactivates this extension.
   */
  virtual void deactivate();

  /**
   * Hides this editor.
   */
  virtual void hide();

 

  /**
   * Loads this extension.
   */
  virtual void load();

 

  /**
   * Shows this editor.
   */
  virtual void show();

  /**
   * Unloads this extension.
   */
  virtual void unload();

public Q_SLOTS:
  /**
   * Clears the text editor.
   */
  virtual void clear();

  /**
   * Copies the selected text to the clipboard.
   */
  virtual void copy();

  /**
   * Deletes the selected text and copies it to the clipboard.
   */
  virtual void cut();

  /**
   * Pastes the text from the clipboard into the text editor at 
   * the current cursor position.
   */
  virtual void paste();

  /**
   * Redoes the last operation.
   */
  virtual void redo();

  /**
   * Reloads the current file.
   */
  virtual void reload();

  /**
   * Saves the content of the text editor in the opened file.
   */
  virtual void save();

  /**
   * Undoes the last operation.
   */
  virtual void undo();

protected Q_SLOTS:
  /**
   * Edition callbacks
   */
  virtual void setCopyAvailable( bool available );
  virtual void setFileEdited();
  virtual void setRedoAvailable( bool available );
  virtual void setUndoAvailable( bool available );

private:
  /** Sets up this editor. */
  void setUp();

  /** prevents multiple '*' appended when the text is edited. */
  bool m_doItOnce;

  /** Syntax highlighter */
  Ivt_ShaderSyntaxHighlight* m_syntaxHighLight;

  /** File buffer */
  QString m_fileBuffer;

  /** File name */
  QString m_fileName;

  /** Shader to edit */
  SoShaderObject* m_shaderNode;

  /** Containers for this editor. */
 
  QFrame* m_container;
};

#endif // IVT_SHADER_EDITOR_H


