/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/

#ifndef IVT_SHADER_SYNTAX_HIGHLIGHT_H
#define IVT_SHADER_SYNTAX_HIGHLIGHT_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_ShaderSyntaxHighlight
//
//////////////////////////////////////////////////////////////////////////////

#include <QtCore/QHash>

#include <QSyntaxHighlighter>
#include <QTextCharFormat>
#include <QRegularExpression>

// This class provides a highlight mechanism for shaders syntax.

class QTextDocument;

class Ivt_ShaderSyntaxHighlight : public QSyntaxHighlighter
{
public:
  Ivt_ShaderSyntaxHighlight( QTextDocument* parent = 0 );
  virtual ~Ivt_ShaderSyntaxHighlight();

protected:
  void highlightBlock( const QString& text );

private:
  void init();

  struct HighlightingRule
  {
    QRegularExpression pattern;
    QTextCharFormat format;
  };
  QVector<HighlightingRule> m_highlightingRules;

  QRegularExpression m_commentEndExpression;
  QRegularExpression m_commentStartExpression;

  QRegularExpression m_groupExpression;
  QRegularExpression m_minMaxExpression;

  QTextCharFormat m_multiLineCommentFormat;
  QTextCharFormat m_singleLineCommentFormat;

  QTextCharFormat m_shdBoolean;
  QTextCharFormat m_shdBuiltins;
  QTextCharFormat m_shdConditional;
  QTextCharFormat m_shdConstants;
  QTextCharFormat m_shdFunctions;
  QTextCharFormat m_shdGroup;
  QTextCharFormat m_shdMembers;
  QTextCharFormat m_shdRepeat;
  QTextCharFormat m_shdSemantic;
  QTextCharFormat m_shdState;
  QTextCharFormat m_shdStatement;
  QTextCharFormat m_shdStorageClass;
  QTextCharFormat m_shdStructure;
  QTextCharFormat m_shdSwizzleCoordinate;
  QTextCharFormat m_shdSwizzleRGBA;
  QTextCharFormat m_shdSwizzleTexCoord;
  QTextCharFormat m_shdTodo;
  QTextCharFormat m_shdType;
};

#endif // IVT_SHADER_SYNTAX_HIGHLIGHT_H


