/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/

#ifndef IVT_SHADER_SYNTAX_KEYWORDS_H
#define IVT_SHADER_SYNTAX_KEYWORDS_H

// Lists of keywords for shaders syntax highlight
// and colors.
// All is based on http://www.vim.org/scripts/script.php?script_id=1002

#include <QColor>

// Colors "almost" based on emacs highlightings
QColor g_boolean = Qt::darkCyan;
QColor g_builtins = Qt::darkRed;
QColor g_comment = Qt::red;
QColor g_conditional = Qt::darkMagenta;
QColor g_constants = Qt::darkYellow;
QColor g_functions = Qt::blue;
QColor g_groups = Qt::magenta;
QColor g_members = Qt::magenta;
QColor g_repeat = Qt::darkMagenta;
QColor g_semantic = Qt::darkYellow;
QColor g_state = Qt::darkYellow;
QColor g_statement = Qt::darkMagenta;
QColor g_storageClass = Qt::darkMagenta;
QColor g_structure = Qt::darkMagenta;
QColor g_swizzles = Qt::darkRed;
QColor g_todo = Qt::darkRed;
QColor g_type = Qt::darkGreen;

//-------------------------------------------------------------------------------
const char* g_shdBoolean[] = {
  "true", "false",
  NULL
};

const char* g_shdBuiltins[] = {
  "gl_Position", "gl_PointSize", "gl_ClipVertex",
  "gl_FragCoord", "gl_FrontFacing", "gl_FragColor",
  "gl_FragData", "gl_FragDepth",
  "gl_Color", "gl_SecondarColor", "gl_Normal", "gl_Vertex",
  "gl_MultiTexCoord0",
  "gl_MultiTexCoord1",
  "gl_MultiTexCoord2",
  "gl_MultiTexCoord3",
  "gl_MultiTexCoord4",
  "gl_MultiTexCoord5",
  "gl_MultiTexCoord6",
  "gl_MultiTexCoord7",
  "gl_FogCoord",
  "gl_NormalScale",
  "gl_ClipPlane",
  "gl_DepthRangeParameters", "gl_DepthRange",
  "gl_PointParameters", "gl_Point",
  "gl_MaterialParameters", "gl_FrontMaterial", "gl_BackMaterial",
  "gl_LightSourceParameters", "gl_LightSource",
  "gl_LightModelParameters", "gl_LightModel",
  "gl_LightModelProducts", "gl_FrontLightModelProduct", "gl_BackLightModelProduct",
  "gl_LightProducts", "gl_FrontLightProduct", "gl_BackLightProduct",
  "gl_TextureEnvColor",
  "gl_EyePlaneS",
  "gl_EyePlaneT",
  "gl_EyePlaneR",
  "gl_EyePlaneQ",
  "gl_ObjectPlaneS",
  "gl_ObjectPlaneT",
  "gl_ObjectPlaneR",
  "gl_ObjectPlaneQ",
  "gl_FogParameters", "gl_Fog",
  "gl_FrontColor", "gl_BackColor", "gl_FrontSecondaryColor", "gl_BackSecondaryColor", "gl_TexCoord", "gl_FogFragCoord",
  "gl_Color", "gl_SecondaryColor", "gl_TexCoord", "gl_FogFragCoord",
  NULL
};

const char* g_shdConditional[] = {
  "if", "else",
  NULL,
};

const char* g_shdConstants[] = {
  "gl_MaxLights", "gl_MaxClipPlanes",
  "gl_MaxTextureUnits", "gl_MaxTextureCoords",
  "gl_MaxVertexAttribs",
  "gl_MaxVaryingFloats",
  "gl_MaxVertexTextureImageUnits",
  "gl_MaxCombinedTextureImageUnits",
  "gl_MaxTextureImageUnits",
  "gl_MaxTextureImageUnits",
  "gl_MaxFragmentUniformComponents",
  "gl_MaxDrawBuffers",
  NULL
};

const char* g_shdFunctions[] = {
  "radians", "degrees" "sin", "cos", "tan", "asin", "acos", "atan",
  "pow", "exp", "log", "exp2", "log2", "sqrt", "inversesqrt",
  "abs", "sign", "floor", "ciel", "fract", "mod", "min", "max", "clamp", "mix",
  "step", "smoothstep",
  "length", "distance", "dot", "cross", "normalize", "ftransform",
  "faceforward", "reflect", "refract", "matrixCompMult",
  "lessThan", "lessThanEqual", "greaterThan", "greaterThanEqual",
  "equal", "notEqual", "any", "all", "not",
  "texture1D", "texture1DProj", "texture1DLod", "texture1DProjLod",
  "texture2D", "texture2DProj", "texture2DLod", "texture2DProjLod",
  "texture3D", "texture3DProj", "texture3DLod", "texture3DProjLod",
  "textureCube", "textureCubeLod",
  "shadow1D", "shadow1DProj", "shadow1DLod", "shadow1DProjLod",
  "shadow2D", "shadow2DProj", "shadow2DLod", "shadow2DProjLod",
  "dFdx", "dFdy", "fwidth",
  "noise1", "noise2", "noise3", "noise4",
  NULL
};

const char* g_shdMembers[] = {
  "near", "far", "diff",
  "size", "sizeMin", "sizeMax", "fadeThresholdSize",
  "distanceConstantAttenuation",
  "distanceLinearAttenuation",
  "distanceQuadraticAttenuation",
  "emission", "ambient", "diffuse", "specular", "shininess",
  "position", "halfVector",
  "spotDirection", "spotExponent", "spotCutoff", "spotCosCutoff",
  "constantAttenuation", "linearAttenuation", "quadraticAttenuation",
  "sceneColor",
  "color", "density", "start", "end", "scale",
  NULL
};

const char* g_shdRepeat[] = {
  "while", "for", "do",
  NULL
};

const char* g_shdSemantic[] = {
  "attribute",
  "in", "out", "inout",
  NULL
};

const char* g_shdState[] = {
  "gl_ModelViewMatrix",
  "gl_ProjectionMatrix",
  "gl_ModelViewProjectionMatrix",
  "gl_TextureMatrix",
  "gl_NormalMatrix",
  "gl_ModelViewMatrixInverse",
  "gl_ProjectionMatrixInverse",
  "gl_ModelViewProjectionMatrixInverse",
  "gl_TextureMatrixInverse",
  "gl_ModelViewMatrixTranspose",
  "gl_ProjectionMatrixTranspose",
  "gl_ModelViewProjectionMatrixTranspose",
  "gl_TextureMatrixTranspose",
  "gl_ModelViewMatrixInverseTranspose",
  "gl_ProjectionMatrixInverseTranspose",
  "gl_ModelViewProjectionMatrixInverseTranspose",
  "gl_TextureMatrixInverseTranspose",
  NULL
};

const char* g_shdStatement[] = {
  "break", "continue", "discard", "return",
  NULL
};

const char* g_shdStorageClass[] = {
  "const", "uniform", "varying",
  NULL
};

const char* g_shdStructure[] = {
  "struct",
  NULL
};

const char* g_shdTodo[] = {
  "contained", "TODO", "FIXME", "XXX",
  NULL
};

const char* g_shdType[] = {
  "float", "int", "void", "bool",
  "mat2", "mat3", "mat4",
  "vec2", "vec3", "vec4", "ivec2", "ivec3", "ivec4", "bvec2", "bvec3", "bvec4",
  "sampler1D", "sampler2D", "sampler3D",
  "samplerCUBE", "sampler1DShadow", "sampler2DShadow",
  NULL
};

#endif // IVT_SHADER_SYNTAX_KEYWORDS_H


