/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_VIEWING_TOOLBAR_H
#define IVT_VIEWING_TOOLBAR_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_ViewingToolbar
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtExtension.h>

#include <QtCore/QObject>

/** 
 * @VSGEXT IvTune class that adds a viewing toolbar.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class implements a viewing toolbar that contains the viewer 
 * buttons as well as full scene antialiasing, shadows and edge activation.
 *
 */

class IvtShell;

class SoGuiAlgoViewers;
class SoQtFullViewer;
class QAction;
class QToolBar;


class Ivt_ViewingToolbar :  public IvtExtension
{

  Q_OBJECT

public:
  /**
   * Constructor.
   */
  Ivt_ViewingToolbar();

  /**
   * Destructor.
   */
  virtual ~Ivt_ViewingToolbar();

  /**
   * Returns the viewing toolbar.
   */
  QToolBar* getViewingToolbar() const;

  // Methods redifined from IvtExtension
  /**
   * Activates this extension.
   */
  virtual void activate();

  /**
   * Deactivates this extension.
   */
  virtual void deactivate();

  /**
   * Hides this extension.
   */
  virtual void hide();

  /**
   * Registers this extension.
   */
  virtual void load();

  /**
   * Shows this extension.
   */
  virtual void show();

  /**
   * Unregisters this extension.
   */
  virtual void unload();

public Q_SLOTS:

  /**
   * Enables the full screen anti aliasing if true.
   */
  virtual void setFSAA( bool enable );

  /**
   * Enables the shadows if true.
   */
  virtual void setShadows( bool enable );

  /**
   * Enables the edges if true.
   */
  virtual void setEdges( bool enable );

  /**
   * Opens the stereo dialog.
   */
  virtual void setStereo();

  /**
   * Enables the picking mode if true.
   */
  virtual void pick( bool enable );

  /**
   * Enables the viewing mode if true.
   */
  virtual void view( bool enable );

  /**
   * Enables the translation if true.
   */
  virtual void setTranslation( bool enable );

  /**
   * Enables the zoom mode if true.
   */
  virtual void setZoom( bool enable );

  /**
   * Enables the rotation mode if true.
   */
  virtual void setRotation( bool enable );

  /**
   * Enables the seeking if true.
   */
  virtual void seek();

  /**
   * Sets the camera to its origin position.
   */
  virtual void home();

  /**
   * Sets the origin position of the camera.
   */
  virtual void setHome();

  /**
   * Toggles the camera from perspective to orthogonal.
   */
  virtual void toggleCamera( bool enable );

  /**
   * Sets the camera to view the whole scene.
   */
  virtual void viewAll();

  /**
   * Sets the camera to view the XY plan.
   */
  virtual void setXYPlan();

  /**
   * Sets the camera to view the XZ plan.
   */
  virtual void setXZPlan();

  /**
   * Sets the camera to view the YZ plan.
   */
  virtual void setYZPlan();

private:
  /** Builds the viewing toolbar and sets it in the GUI */
  void buildViewingToolbar();

  /** Resets this tool bar to its initial state */
  void resetToolBar();

  /** Restores viewer's state */
  void restoreState();

  /** Stops current viewer animations */
  void stopAnimations();

  /** Saves viewer's state (deco on/off and viewing mode) */
  void saveState();

  /** Sets the new cursors for the viewer */
  void setViewingCursors();

  /** Provides access to viewers algoritms */
  SoGuiAlgoViewers* m_gav;

  /** Provides access to viewers */
  SoQtFullViewer* m_viewer;

  /** True if IvTune has its own viewer */
  bool m_isOffline;

  /** Viewing toobar */
  QToolBar* m_viewingToolbar;

  /** Edges action */
  QAction* m_edgesAction;

  /** FSAA action */
  QAction* m_fsaaAction;
  
  /** Picking action */
  QAction* m_pickAction;

  /** Rotation action */
  QAction* m_rotateAction;

  /** Shadows action */
  QAction* m_shadowsAction;

  /** Toggle camera action */
  QAction* m_toggleCamera;

  /** Translation  action */
  QAction* m_translateAction;

  /** Viewing action */
  QAction* m_viewAction;

  /** Zoom action */
  QAction* m_zoomAction;

  /** Variables to save the state (decoration on/off and viewing mode) */
  int m_oldViewingMode;
  bool m_oldDecoration, m_oldViewing, m_restored;
};

#endif // IVT_VIEWING_TOOLBAR_H


