/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_LDM_CONTROL_PARAMETERS_H
#define IVT_LDM_CONTROL_PARAMETERS_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_LDMControlParameters
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtEditor.h>

#include <ui_Ivt_LDMControlParameters_UI.h>

/** 
 * @VSGEXT IvTune editor for LDM resource parameters.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class provides an editor to interact with SoLDMResourceParameters nodes
 * and SoLDMGlobalResourceParameters.
 *
 */

class SoField;
class SoLDMResourceParameters;
class SoNode;

class QDockWidget;
class QFrame;

class Ivt_LDMControlParameters : public IvtEditor, public Ui::LDMControlEditor
{

  Q_OBJECT

public:
  /**
   * Constructor.
   */
  Ivt_LDMControlParameters();

  /**
   * Destructor.
   */
  virtual ~Ivt_LDMControlParameters();

  // Methods redifined from IvtExtension, IvtEditor and IvtFieldEditor
  /**
   * Activates this extension.
   */
  virtual void activate();

  /**
   * Deactivates this extension.
   */
  virtual void deactivate();

  /**
   * Hides this editor.
   */
  virtual void hide();

  /**
   * Loads this extension.
   */
  virtual void load();

  /**
   * Shows this editor.
   */
  virtual void show();

  /**
   * Unloads this extension.
   */
  virtual void unload();

public Q_SLOTS:
  // Visual Feedback group
  /**
   * Sets the drawing of the tiles if true.
   */
  virtual void setDrawTiles( bool enabled );

  /**
   * Sets the slice textures if true.
   */
  virtual void setSliceTextures( bool enabled );

  /**
   * Sets fake data if true.
   */
  virtual void setFakeData( bool enabled );

  /**
   * Loads the the tiles if true.
   */
  virtual void setLoadUnloadTiles( bool enabled );

  /**
   * Sets texture front outline if true.
   */
  virtual void setTextureFrontOutline( bool enabled );

  /**
   * Sets data front outline if true.
   */
  virtual void setDataFrontOutline( bool enabled );

  /**
   * Sets valuation outline if true.
   */
  virtual void setValuationOutline( bool enabled );
  

  // Options group
  /**
   * Sets the culling for the view if true.
   */
  virtual void setViewCulling( bool enabled );

  /**
   * Loads tiles for which the projection of a voxel is
   * greater than or equal to 1 pixel on screen if true.
   */
  virtual void setScreenResolution( bool enabled );

  /**
   * Sets the viewpoint refinement if true.
   */
  virtual void setViewPointRefinement( bool enabled );

  /**
   * Draws SoOrthoSlice and SoObliqueSlice with the same
   * resolution if true.
   */
  virtual void setSliceEqualResolution( bool enabled );

  /**
   * Ignores fully transparent tiles if true.
   */
  virtual void setIgnoreFullyTransparentTiles( bool enabled );

  /**
   * Sets the fixed resolution mode if true if true.
   */
  virtual void setFixedResolutionMode( bool enabled );

  /**
   * Callbacks for the combo boxes.
   */
  virtual void tileSizeCB( int index );
  virtual void subtilesSizeCB( int index );
  virtual void loadingPolicyCB( int index );
  virtual void minResThresholdCB( int index );
  virtual void maxResThresholdCB( int index );
  virtual void reqResCB( int index );

  /**
   * Callback for the loading threads slider.
   */
  virtual void optNLTSliderCB( int value );
  

  // Main Memory Control parameters group
  /**
   * Sliders callbacks.
   */
  virtual void mmcpAmountSliderCB( int value );
  virtual void mmcpNRSliderCB( int value );
  

  // Control parameters for Volume Texturing group
  /**
   * Sliders callbacks.
   */
  virtual void cpvtAmountSliderCB( int value );
  virtual void cpvtTLRSliderCB( int value );
  

  // Control parameters for Slice Texturing group
  /**
   * Sliders callbacks.
   */
  virtual void cpstTLRSliderCB( int value );

protected Q_SLOTS:
  /**
   * Callbacks for the line editors of the sliders.
   */
  virtual void optNLTLECB();
  virtual void mmcpAmountLECB();
  virtual void mmcpNRLECB();
  virtual void cpvtAmountLECB();
  virtual void cpvtTLRLECB();
  virtual void cpstTLRLECB();

  /**
   * Callbacks to set/unset the tracking mode of the 
   * sliders.
   */
  virtual void setOptNLTSliderInt( bool enabled );
  virtual void setMmcpAmountSliderInt( bool enabled );
  virtual void setMmcpNRSliderInt( bool enabled );
  virtual void setCpvtAmountSliderInt( bool enabled );
  virtual void setCpvtTLRSliderInt( bool enabled );
  virtual void setCpstTLRSliderInt( bool enabled );

private:
  /** Sets up this editor. */
  void setUp();

  /** Updates the sliders */
  void updateSliders();

  /** Editor node. */
  SoLDMResourceParameters* m_ldmRPNode;

  /** Containers for this editor. */
  QFrame* m_container;
};

#endif // IVT_LDM_CONTROL_PARAMETERS_H


