include( ${OIV_COMMON_CMAKE_DIR}/OIVVersion.cmake )                     # current OIV version

####################################
###### COMMON COMPILERS FLAGS ######
####################################
add_definitions(-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64)

###### OpenMP support flags
option(OIV_ENABLE_OPENMP "Enable OpenMP usage" TRUE)
FIND_PACKAGE(OpenMP)

if(${CMAKE_CXX_PLATFORM_ID} MATCHES "OSX")
  set(OIV_ENABLE_OPENMP FALSE CACHE BOOL "OFF on MAC" FORCE)
endif()

if (OIV_ENABLE_OPENMP AND OPENMP_FOUND)
  if(MSVC)
    # only release version use OpenMP
    set(CMAKE_CXX_FLAGS_MINSIZEREL "${OpenMP_CXX_FLAGS} ${CMAKE_CXX_FLAGS_MINSIZEREL} -DOIV_ENABLE_OPENMP" )
    set(CMAKE_CXX_FLAGS_RELEASE "${OpenMP_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE} -DOIV_ENABLE_OPENMP" )
    set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${OpenMP_CXX_FLAGS} ${CMAKE_CXX_FLAGS_RELWITHDEBINFO} -DOIV_ENABLE_OPENMP" )
  else()
    add_definitions(-DOIV_ENABLE_OPENMP)
    set(CMAKE_CXX_FLAGS "${OpenMP_CXX_FLAGS} ${CMAKE_CXX_FLAGS}")
  endif()
endif()


##### VRML deprecation
include(CMakeDependentOption)
# this provides the OIV_IGNORE_VRML_DEPRECATED option only if OIV_DEV_BUILD is true. Otherwise defaults to False
CMAKE_DEPENDENT_OPTION(OIV_NODEPRECATE_VRML "Ignore VRML deprecation" TRUE "OIV_DEV_BUILD" FALSE)

if(OIV_NODEPRECATE_VRML)
  add_definitions(-DOIV_IGNORE_VRML_DEPRECATED)
endif()



####################################
###### GNU GCC COMPILERS FLAGS
####################################
set(common_flags "-msse2 -W -Wall -fno-strict-aliasing -Wno-comments")
set(common_flags "${common_flags}  -Werror=pointer-arith")
set(OIV_GNUCC_COMMON_FLAGS ${common_flags} CACHE STRING "Common flags for all GCC builds.")
mark_as_advanced(OIV_GNUCC_COMMON_FLAGS)

if(APPLE)
  set (CMAKE_CXX_STANDARD 11)
endif()

if(CMAKE_COMPILER_IS_GNUCC)
  #Enable C++ 11 Option
  set (CMAKE_CXX_STANDARD 11)
  
  #Enable FPIC Option
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fPIC")
  
  option(VISIBILITY_HIDDEN "Do not export internal use only symbols" TRUE)
  if(VISIBILITY_HIDDEN)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden")
  endif()
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OIV_GNUCC_COMMON_FLAGS}")
  set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OIV_GNUCC_COMMON_FLAGS}")
  if(NOT OIV_CXX_COMPILER_VERSION MATCHES 32)
    set(CMAKE_CXX_FLAGS "-Wno-invalid-offsetof ${CMAKE_CXX_FLAGS}")
  endif()

  # Resolve symbols recursively required by the output binary. This was the default value before GCC 4.5.
  # TODO: remove this workaround in OIV 10
  if (CMAKE_CXX_COMPILER_VERSION_DOT VERSION_GREATER "4.4")
    set(CMAKE_EXE_LINKER_FLAGS  "-Wl,--copy-dt-needed-entries")
  endif()

  if(CMAKE_BUILD_TYPE MATCHES "^(Debug)$" OR CMAKE_BUILD_TYPE MATCHES "^(debug)$")

    add_definitions(-DDEBUG -D_DEBUG)

    option(STL_DEBUG "Enable debug version of the stl library." FALSE)
    if(STL_DEBUG)
      add_definitions(-D_GLIBCXX_DEBUG)
    endif()

    option(FULL_DEBUG_LEVEL "Use debugging level 3" FALSE)
    if(FULL_DEBUG_LEVEL)
      add_definitions(-g3)
    endif()

    option(OIV_TESTS_COVERAGE "Enable coverage analysis (Debug only)" FALSE)
    if(OIV_TESTS_COVERAGE)
      set(CMAKE_CXX_FLAGS_DEBUG "-fdiagnostics-show-option -fprofile-arcs -ftest-coverage ${CMAKE_CXX_FLAGS_DEBUG}")
      set(CMAKE_C_FLAGS_DEBUG   "-fdiagnostics-show-option -fprofile-arcs -ftest-coverage ${CMAKE_C_FLAGS_DEBUG}")
      set(CMAKE_EXE_LINKER_FLAGS_DEBUG "-fprofile-arcs -ftest-coverage ${CMAKE_EXE_LINKER_FLAGS_DEBUG}")
      set(CMAKE_MODULE_LINKER_FLAGS_DEBUG "-fprofile-arcs -ftest-coverage ${CMAKE_MODULE_LINKER_FLAGS_DEBUG}")
      set(CMAKE_SHARED_LINKER_FLAGS_DEBUG "-fprofile-arcs -ftest-coverage ${CMAKE_SHARED_LINKER_FLAGS_DEBUG}")
    endif()

  endif()

  if(OIV_ENABLE_HASH_STYLE_COMPAT)
    set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -Wl,--hash-style=both")
  endif()

  if(CMAKE_VERBOSE_MAKEFILE)
    # force gcc one line message generation : helps some tools (eclipse...) to parse error messages
    # only activated in verbose mode because versbose mode is usually also required
    add_definitions(-fmessage-length=0)
  endif()

  set(CMAKE_SKIP_BUILD_RPATH true)

  option(OIV_BUILD_RPATH "Use rpath on Linux" FALSE)

  # Always activate OIV_BUILD_RPATH in DEV_BUILD
  if(OIV_DEV_BUILD)
    set(OIV_BUILD_RPATH TRUE CACHE BOOL "Use rpath on Linux" FORCE)
  endif()

  if(OIV_BUILD_RPATH)
    set(CMAKE_SKIP_BUILD_RPATH false)
  endif()


endif()

####################################
###### APPLE CLANG COMPILERS FLAGS
####################################
if ( APPLE AND CMAKE_CXX_COMPILER_ID MATCHES "Clang" ) # Clang or AppleClang
  # use, i.e. don't skip the full RPATH for the build tree
  set(CMAKE_SKIP_BUILD_RPATH FALSE)
  set(CMAKE_MACOSX_RPATH ON)
  set(CMAKE_SKIP_RPATH NO)

  # when building, use the install RPATH
  set(CMAKE_BUILD_WITH_INSTALL_RPATH TRUE)

  # rpath value (dynamic linking to find the libraries the executable or library requires)
  set(PACKAGE_INSTALLATION_PATH "/Applications/OpenInventor.app/")
  set(OIV_INSTALLATION_PATH "${PACKAGE_INSTALLATION_PATH}Contents/${OIV_VERSION_MAJOR}.${OIV_VERSION_MINOR}.${OIV_VERSION_PATCH}")

  # Specify the rpath to use in installed targets on OSX
  if(OIV_DEV_BUILD)
    set(CMAKE_INSTALL_RPATH "@executable_path/;@executable_path/Qt/lib;${CMAKE_SOURCE_DIR}/OIVHOME/${OIVARCH}/lib;${CMAKE_SOURCE_DIR}/OIVHOME/${OIVARCH}/lib/Qt/lib")
  else()
    if (Qt5_DIR)
        set(CMAKE_INSTALL_RPATH "@executable_path/;@executable_path/Qt/lib;${OIV_INSTALLATION_PATH}/${OIVARCH}/lib;${OIV_INSTALLATION_PATH}/${OIVARCH}/lib/Qt/lib;${Qt5_DIR}/../..")
    else()
        set(CMAKE_INSTALL_RPATH "@executable_path/;@executable_path/Qt/lib;${OIV_INSTALLATION_PATH}/${OIVARCH}/lib;${OIV_INSTALLATION_PATH}/${OIVARCH}/lib/Qt/lib")
    endif()
  endif()
endif()

####################################
###### MSVC COMPILERS FLAGS
####################################
if (MSVC)

  option(OIV_FORCE_LOCAL_ASSEMBLY "Force linker to use latest local CRT version " TRUE)
  mark_as_advanced( OIV_FORCE_LOCAL_ASSEMBLY )
  if(OIV_FORCE_LOCAL_ASSEMBLY)
    add_definitions(-D_BIND_TO_CURRENT_VCLIBS_VERSION=1)
    add_definitions(-D_BIND_TO_CURRENT_CRT_VERSION=1)
    add_definitions(-D_BIND_TO_CURRENT_CRT_VERSION=1)
    add_definitions(-D_BIND_TO_CURRENT_ATL_VERSION=1)
    add_definitions(-D_BIND_TO_CURRENT_MFC_VERSION=1)
    add_definitions(-D_BIND_TO_CURRENT_OPENMP_VERSION=1)
  endif()

  # While in OIV_DEV_BUILD mode, disable autolink to reduce missing lib dependency in cmakefiles
  if(OIV_DEV_BUILD)
    option(OIV_DISABLE_AUTOLINK "Ignore pragma comment(lib,libname) directives in public headers" TRUE)
  else()
    option(OIV_DISABLE_AUTOLINK "Ignore pragma comment(lib,libname) directives in public headers" FALSE)
  endif()
  mark_as_advanced( OIV_DISABLE_AUTOLINK )
  
  if(OIV_DISABLE_AUTOLINK)
    add_definitions(-DOIV_DISABLE_AUTOLINK)
  endif()

  set(CMAKE_CXX_FLAGS_MINSIZEREL "/D_SECURE_SCL=1 ${CMAKE_CXX_FLAGS_RELEASE}" )
  set(CMAKE_CXX_FLAGS_RELEASE "/D_SECURE_SCL=0 ${CMAKE_CXX_FLAGS_RELEASE}" )
  set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "/D_SECURE_SCL=0 ${CMAKE_CXX_FLAGS_RELWITHDEBINFO}" )

  option(OIV_ENABLE_RELEASE_DEBUG_INFO "Add debug information to PDB in release mode" TRUE)
  mark_as_advanced( OIV_ENABLE_RELEASE_DEBUG_INFO )
  if(OIV_ENABLE_RELEASE_DEBUG_INFO)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /Zi" )
  endif()

  if (CMAKE_CL_64)
    add_definitions(/DWIN64)
  endif()

  # We add the force warning as error
  option(OIV_FORCE_WARNING_AS_ERROR "Force Warning as Error for all OIV" TRUE)
  if (OIV_FORCE_WARNING_AS_ERROR)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /WX")
    set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} /WX")
  endif()
   
  if(OIV_CXX_COMPILER_VERSION MATCHES "^8$")
    add_definitions(/Wp64)
  endif()

  if(MSVC_VERSION GREATER 1500)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /MP" )
  endif()

  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /W3" )
  add_definitions(/D_CRT_SECURE_NO_DEPRECATE)
  set(CMAKE_CXX_FLAGS_DEBUG "/DDEBUG ${CMAKE_CXX_FLAGS_DEBUG}" )
  set(CMAKE_SHARED_LINKER_FLAGS "/DEBUG ${CMAKE_SHARED_LINKER_FLAGS}" )

  set(CMAKE_RC_FLAGS_DEBUG "${CMAKE_RC_FLAGS_DEBUG} /DDEBUG /D_DEBUG" )
  #to support more than 64K addressable sections (large template source files)
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /bigobj" )
  
  # Disable warning C4251
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /wd4251" )
endif()
