# - Try to find OpenCL
# Once done this will define
#  
#  OPENCL_FOUND        - system has OpenCL
#  OPENCL_LIBRARY      - link these to use OpenCL
#  OPENCL_LIB_DIR      - add this directory in lib path to use OpenCL
#

IF(OIV_TOOLKIT_BUILD)
  ## BIG HACK for now
  SET( OPENCL_FOUND TRUE )
  SET( OPENCL_LIB_DIR "${CMAKE_BINARY_DIR}/prepacked/OpenCL/lib/" )
else()

  # Be sure the shared OpenCL library is present
  find_library( OPENCL_RUNTIME OpenCL )
  
  # Be sure the OpenCL link library is present
  if( OPENCL_RUNTIME AND DEFINED OPENCL_LIB_DIR AND IS_DIRECTORY ${OPENCL_LIB_DIR} )
    set( OPENCL_FOUND TRUE )
  else()
    set( OPENCL_FOUND FALSE )
    message( STATUS "Please define OPENCL_LIB_DIR to locate OpenCL toolkit library." )
  endif()

endif()

if(MSVC)
  SET( OPENCL_LIBRARY "OpenCL.lib" )
else()
  SET( OPENCL_LIBRARY "OpenCL" )
endif()

