# #################################################################################
# This macro inits the testing subsystem.
# #################################################################################

# only include this file once
if(oiv_test_included)
  return()
endif()
set(oiv_test_included true)


# define DATAHOME if it is not in the environment
if(NOT ENV{DATAHOME})
  if(WIN32)
    set(DATAHOME "\\\\frbor-qa-data01\\dataset1\\OpenInventor\\OIV_Ebugs_Data_Files")
  else()
    set(DATAHOME "/mnt/dataset1/OpenInventor/OIV_Ebugs_Data_Files")
  endif()
else()
  set(DATAHOME $ENV{DATAHOME})
endif()
file(TO_CMAKE_PATH "${DATAHOME}" DATAHOME)

MACRO( OivTestsInit )
  option( OIV_ENABLE_TESTS "Enable testing" FALSE )
  mark_as_advanced( OIV_ENABLE_TESTS )

  set(OIV_ART_TEST_CONFIGS_CACHE "")
  ADD_TEST_CONF("default")
  # Configure CTest variables before including the module (otherwise, they are ignored)
  SET(DART_TESTING_TIMEOUT "300" CACHE STRING "")
  include(CTest)

  if(OIV_ENABLE_TESTS)

    # Display specific tests configuration in CDASH reports
    set( OIV_TESTS_NAME "" CACHE STRING "Display specific tests name in CDASH reports" )
    option( OIV_TESTS_ENABLE_PAGEHEAP "Enable PageHeap for the tests (must run the tests in admin mode on Windows 7)" FALSE )
    site_name(HOSTNAME_UPPER)
    set(OIV_REFERENCE_MACHINE ${HOSTNAME_UPPER} CACHE STRING "Select machine named to be used as reference for image comparison"  )
    find_package(Python REQUIRED)
    find_path(OIVHOME include/SoDebug.h "$ENV{OIVHOME}")

    string(TOLOWER ${OIV_REFERENCE_MACHINE} HOSTNAME)
    # Remove dots from hostname
    string(REPLACE "." ";" HOSTNAME_LIST ${HOSTNAME})
    list(GET HOSTNAME_LIST 0 HOSTNAME)

    if(NOT EXISTS ${OIVHOME})
      message(STATUS "OIVHOME not found. Set your OIVHOME.")
    endif()

    if(OIV_DEV_BUILD)
      set(OIVHOME ${CMAKE_SOURCE_DIR}/OIVHOME)
    endif()

    message(STATUS "OIV_ART_REFERENCES_SUBMOD set to ${OIV_ART_REFERENCES_SUBMOD} ")

    # make sure to get a full path to the output dir
    get_filename_component(OIV_TESTS_OUTPUT_PATH ${OIV_TESTS_OUTPUT_PATH} REALPATH)

    set(OIV_TESTS_ACTIVATED_MODULES "all" CACHE STRING "Modules or art files (without path) to test separated by spaces. (Ex: \"all\" or \"VolumeViz OpenInventor\" or \"art1414.art\")")

  endif()

ENDMACRO()

##################################################################################

#Private : I.E. NOT TO CALL OUTSIDE THIS FILE !!!
#core macro factorizing code for ADD_TEST_WITHOUT_ART and ADD_UNITTEST_TEST
#not the perfect thing to do but one step further in the good direction to have
#a unique macro to add test not based on ART
#ADD_UNITTEST_CORE(testname0 testExecutable0 [ENVIRONMENT env] [SUITE suite])
FUNCTION( ADD_UNITTEST_CORE testname0 testExecutable0 )

  IF(OIV_ENABLE_TESTS)
    set(options DEMOS UNITTESTS)
    set(oneValueArgs ENVIRONMENT)
    set(multiValueArgs "")
    cmake_parse_arguments(test "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

    if(test_UNITTESTS)
      set(SUITE_PATH "UnitTests")
    elseif(test_DEMOS)
      set(SUITE_PATH "OIVHOME/examples/source")
    endif()

    if(OIV_DEV_BUILD)
      set(OIVHOME ${CMAKE_SOURCE_DIR}/OIVHOME)
    else()
      set(OIVHOME $ENV{OIVHOME})
    endif()
    FILE(TO_CMAKE_PATH "${OIVHOME}" OIVHOME)

    FILE( TO_CMAKE_PATH ${CMAKE_CURRENT_LIST_FILE} module )
    FILE( TO_CMAKE_PATH ${OIV_TESTS_REFERENCE_PATH} refPath )

    STRING(REGEX REPLACE "(.*)/${SUITE_PATH}/(.*)/(.*)" "\\2" module "${module}")
    STRING(REGEX REPLACE "(.*)/(.*)" "\\1" module "${module}")

    FIX_EXECUTABLE_PATH_FUNC(${testname0} "Release" testName)
    FILE( TO_CMAKE_PATH ${testName} testName )

    FIX_EXECUTABLE_PATH_FUNC(${testExecutable0} "Release" testExecutable)
    FILE( TO_CMAKE_PATH ${testExecutable} testExecutable )

    FIX_EXECUTABLE_PATH_FUNC_ARRAY("" "Release" args ${test_UNPARSED_ARGUMENTS})

    # retrieve path to current binary, starting from ${module} folder:
    # retrieve full path and remove all path preceding ${module}

    if(test_UNITTESTS)
      if(${testExecutable0} MATCHES ".*ShapeReworkIvRenderer")
        get_filename_component(refName "${testExecutable}" NAME)
      else()
        get_filename_component(refName "${CMAKE_CURRENT_BINARY_DIR}" ABSOLUTE)
        STRING( REGEX REPLACE ".*${module}/" "" refName ${refName} )
      endif()
    elseif(test_DEMOS)
      get_filename_component(refName "${testExecutable0}" DIRECTORY)
      STRING( REGEX REPLACE ".*${module}/" "" refName ${refName} )
    endif()

    SET( artReferenceFilePath "${refPath}/${module}/${refName}" )
    FILE( TO_CMAKE_PATH ${OIV_TESTS_OUTPUT_PATH} outputPath )
    SET( artOutputFilePath "${outputPath}/${module}/${refName}" )
    SET( testEnvironment "${test_Environment}" )

    #Everything should be in TO_CMAKE_PATH but vbs want to have native mode for path with spaces
    FILE( TO_CMAKE_PATH ${artReferenceFilePath} artReferenceFilePath )
    FILE( TO_CMAKE_PATH ${artOutputFilePath} artOutputFilePath )

    SET(testConfigs "${OIV_TEST_CONFIGS}")

    separate_arguments(testConfigs)
    FOREACH(confName ${testConfigs})

      SET( confValue "" )
      STRING(REGEX REPLACE " " "" confName "${confName}")
      IF(NOT "${confName}" STREQUAL "default")
        FILE(STRINGS $ENV{OIVHOME}/../cmake/${confName}.cfg confValue NEWLINE_CONSUME)
      ENDIF()

      set( confValue "${${test_ENVIRONMENT}} OIV_TEST_CONF_NAME=${confName} ${confValue}" )
      separate_arguments(confValue)
      SET( confValue "OIV_TEST_CONFIGS=\"${OIV_TEST_CONFIGS}\";${confValue}" )

      SET(testNameParam "[${confName}]_${testName}")

      SET(runUnitTestScript "${OIVHOME}/source/cmake/runUnitTest.py")
      FILE( TO_CMAKE_PATH ${runUnitTestScript}  runUnitTestScript )
      get_filename_component(runUnitTestScript "${runUnitTestScript}" REALPATH)

      add_test(${testNameParam} ${Python_EXECUTABLE} "-W ignore::DeprecationWarning" "${runUnitTestScript}" "${testExecutable}" "${CMAKE_CURRENT_BINARY_DIR}" "${artReferenceFilePath}" "${testName}" "${artOutputFilePath}" "${GIT_BRANCH_NAME_WITH_PATH}" "${GIT_BRANCH_SHAID}" "\"${OIV_TEST_CONFIGS}\"" "${args}")
      set_property( TEST ${testNameParam} PROPERTY ENVIRONMENT ${confValue} )
      set_property( TEST ${testNameParam} PROPERTY LABEL ${confName} )

    ENDFOREACH()

  ENDIF()

ENDFUNCTION()

##################################################################################
#ADD_UNITTEST(testname [ENVIRONMENT env])
#using this macro defines TEST_NAME, TEST_SRC_DIR, TEST_OUTPUT_DIR and TEST_SNAPSHOT_PREFIX
MACRO( ADD_UNITTEST testname)
  SET_OIV_CMAKE_OUTPUT_DIRECTORIES()
  ADD_UNITTEST_CORE( ${testname} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${testname} UNITTESTS ${ARGN} )
  string(REPLACE ${ROOT_DIR} "" TEST_OUTPUT_DIR ${OIV_TESTS_OUTPUT_PATH} ${CMAKE_CURRENT_SOURCE_DIR})
  target_compile_definitions(${testname} PRIVATE
    TEST_NAME="${testname}"
    TEST_SRC_DIR="${CMAKE_CURRENT_SOURCE_DIR}"
    TEST_OUTPUT_DIR="${TEST_OUTPUT_DIR}"
    TEST_SNAPSHOT_PREFIX="${TEST_OUTPUT_DIR}/${testname}_snapshot"
  )
ENDMACRO()

##################################################################################
#ADD_UNITTEST_TEST(testname0 testExecutable0 [ENVIRONMENT env])
FUNCTION( ADD_UNITTEST_TEST testname0 testExecutable0 )

  ADD_UNITTEST_CORE( ${testname0} ${testExecutable0} UNITTESTS ${ARGN} )

ENDFUNCTION()

##################################################################################
#ADD_TEST_WITHOUT_ART(testname0 testExecutable0 [ENVIRONMENT env])
FUNCTION( ADD_TEST_WITHOUT_ART testname0 testExecutable0 )

  ADD_UNITTEST_CORE( ${testname0} ${testExecutable0} DEMOS ${ARGN} )

ENDFUNCTION()

##################################################################################

#find the full path to the executable used for a test
MACRO(oiv_get_executable targetname exename)

  SET(BUILD_TYPE "Release")
  IF(NOT MSVC)
    STRING(TOLOWER "${CMAKE_BUILD_TYPE}" BUILD_TYPE)
  ENDIF()

  FIX_EXECUTABLE_PATH_FUNC(${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${targetname} ${BUILD_TYPE} ${exename})

ENDMACRO()

find_program(
  ART_EXECUTABLE
  NAMES ART 
  PATHS ${OIVHOME}/arch-${CMAKE_ARCHITECTURE}-release/bin ${OIVHOME}/arch-${CMAKE_ARCHITECTURE}-debug/bin)

#demo
FUNCTION( ADD_ART_TEST )

  IF(OIV_ENABLE_TESTS AND (OIV_ENABLE_ART_TESTS OR OIVTEST_ENABLE_ART OR OIVTEST_ENABLE_ART_EBUG))

    FILE( TO_CMAKE_PATH ${OIVHOME} oivHome )
    FILE( TO_CMAKE_PATH ${OIV_TESTS_OUTPUT_PATH} outputPath )
    FILE( TO_CMAKE_PATH ${OIV_TESTS_REFERENCE_PATH} refPath )

    SET(activeModules "${OIV_TESTS_ACTIVATED_MODULES}")
    separate_arguments(activeModules)

    FOREACH(artTestConfig ${OIV_ART_TEST_CONFIGS_CACHE})

      FOREACH(FILE ${${artTestConfig}List})
        get_filename_component(CURRENT_DIRECTORY "${FILE}" DIRECTORY)
        get_filename_component( module "${FILE}" DIRECTORY )
     
        # The following will remove '*/OIVHOME/examples/source/' from the module path, then will remove '*/UnitTests/' and '*/Ebugs/'.
        # A test path should *never* contain both of these paths.
        # This allows us to retrieve the 'module', i.e. 'Inventor' or 'VolumeViz' in the path.
        # we also do this to extract the rest of the path at the right of the module.
        # these two are separated to guarantee (with a simple enough regexp) that we get everything
        # at the right of the 'module'.
        # We then use it to build the path to the references and output path for this test

        # remove everything up to "/OIVHOME/examples/source/" from 'module'
        STRING(REGEX REPLACE "(.*)/OIVHOME/examples/source/(.*)/(.*)" "\\2" module "${module}")
        # remove everything up to"/UnitTests/" from 'module'
        STRING(REGEX REPLACE "(.*)/UnitTests/(.*)/(.*)" "\\2" module "${module}")
        # remove everything up to"/Ebugs/" from 'module'
        STRING(REGEX REPLACE "(.*)/Ebugs/(.*)/(.*)" "\\2" module "${module}")

        # only keep the first folder name ("A" in "A/B")
        STRING(REGEX REPLACE "/(.*)" "" module "${module}")

        If (OIVTEST_ENABLE_ART_EBUG)
          # remove everything up to"/Ebugs/${module}/" from 'FILE'
          STRING(REGEX REPLACE "(.*)/Ebugs/${module}/(.*)" "\\2" baseFilename ${FILE})
        else ()
           # remove everything up to"/UnitTests/${module}/" from 'FILE'
           STRING(REGEX REPLACE "(.*)/UnitTests/${module}/(.*)" "\\2" baseFilename ${FILE})
           # remove everything up to"/examples/source/${module}/" from the previously  modified 'baseFilename'
           STRING(REGEX REPLACE "(.*)/examples/source/${module}/(.*)" "\\2" baseFilename ${baseFilename})
        endif()
    
        SET(addTest FALSE)

        get_filename_component( artFilePath "${baseFilename}" DIRECTORY )
        get_filename_component( artFilename "${baseFilename}" NAME )
        get_filename_component( artAbsoluteFile "${FILE}" ABSOLUTE )

        STRING( REPLACE ".art" "" artFilename ${artFilename} )

        SET( artFileDir "${outputPath}/${module}/${artFilePath}" )
        SET( artReferenceFileDir "${refPath}/${module}/${artFilePath}" )

        IF(OIV_TESTS_ENABLE_PAGEHEAP)
          SET( enablePageHeap "1" )
        ELSE()
          SET( enablePageHeap "0" )
        ENDIF()

        #Everything should be in TO_CMAKE_PATH but vbs want to have native mode for path with spaces
        FILE( TO_CMAKE_PATH ${CURRENT_DIRECTORY} CURRENT_DIRECTORY )
        FILE( TO_CMAKE_PATH ${artFileDir} artFileDir )
        FILE( TO_CMAKE_PATH ${artReferenceFileDir} artReferenceFileDir )
        FILE( TO_CMAKE_PATH ${artFilename} artFilename )
        FILE( TO_CMAKE_PATH ${FILE} FILE )
        SET( artParameters "${FILE};-s;0;-o;${artFileDir}" )

        # check for activated module
        SET(addTest FALSE)
        FOREACH(actMod ${activeModules})
          STRING(REGEX MATCH "${actMod}" matched "${artAbsoluteFile}")
          IF(NOT "${matched}" STREQUAL "")
            SET(addTest TRUE)
          ENDIF()
        ENDFOREACH()

        # check IF all modules are active
        STRING(REGEX MATCH "${activeModules}" matched "all")
        IF(addTest OR NOT "${matched}" STREQUAL "")
          SET( confValue "" )
          STRING(REGEX REPLACE " " "" artTestConfig "${artTestConfig}")
          IF(NOT "${artTestConfig}" STREQUAL "default")
            FILE(STRINGS ${oivHome}/../cmake/${artTestConfig}.cfg confValue NEWLINE_CONSUME)
            SET(confValue "OIV_ART_SNAPSHOT_PREFIX=${artTestConfig}_ ${confValue}")
          ENDIF()

          SET( confValue "OIV_TEST_CONF_NAME=${artTestConfig} ${confValue}" )
          separate_arguments(confValue)

          SET(TESTNAME "[${artTestConfig}]_${module}/${baseFilename}")
          add_test(${TESTNAME} ${Python_EXECUTABLE} "-W ignore::DeprecationWarning" "${oivHome}/source/cmake/runTest.py" "${CURRENT_DIRECTORY}" "${ART_EXECUTABLE}" "${artFileDir}" "${artReferenceFileDir}" "${artFilename}" "${artParameters}" "${enablePageHeap}" "${GIT_BRANCH_NAME_WITH_PATH}" "${GIT_BRANCH_SHAID}")
          set_tests_properties( ${TESTNAME} PROPERTIES TIMEOUT 180 )
          set_property( TEST ${TESTNAME} PROPERTY ENVIRONMENT ${confValue} )
          set_property( TEST ${TESTNAME} PROPERTY LABEL ${artTestConfig} )

        ENDIF()

      ENDFOREACH()
    ENDFOREACH()
  ENDIF()

ENDFUNCTION()

# #################################################################################

MACRO( ADD_TEST_CONF confName )

  SET(OIV_TEST_CONFIGS "${confName} ${OIV_TEST_CONFIGS}")

  SET(OIV_ART_TEST_CONFIGS_CACHE "${confName};${OIV_ART_TEST_CONFIGS_CACHE}")
  separate_arguments(OIV_ART_TEST_CONFIGS_CACHE)
  LIST(REMOVE_DUPLICATES OIV_ART_TEST_CONFIGS_CACHE)

  get_filename_component(CURRENT_DIRECTORY "${CMAKE_CURRENT_LIST_FILE}" DIRECTORY)
  FILE(GLOB_RECURSE artFiles "${CURRENT_DIRECTORY}/*.art")
  LIST(LENGTH artFiles lenght)

  IF( NOT "${artFiles}" STREQUAL "" )
    LIST(APPEND ${confName}List ${artFiles})
    LIST(REMOVE_DUPLICATES ${confName}List)
    SET(${confName}List ${${confName}List})
  ENDIF()
  message( STATUS "confName : ${confName} " )
  message( STATUS "OIV_ART_TEST_CONFIGS_CACHE : ${OIV_ART_TEST_CONFIGS_CACHE} " )

ENDMACRO()

# #################################################################################

MACRO( REMOVE_TEST_CONF confName )

  STRING(REGEX REPLACE "${confName}" "" OIV_TEST_CONFIGS "${OIV_TEST_CONFIGS}")
  get_filename_component(CURRENT_DIRECTORY "${CMAKE_CURRENT_LIST_FILE}" DIRECTORY)
  FILE(GLOB_RECURSE artFiles "${CURRENT_DIRECTORY}/*.art")
  separate_arguments(artFiles)

  IF( NOT "${artFiles}" STREQUAL "" )
    LIST(REMOVE_ITEM ${confName}List ${artFiles})
    SET(${confName}List ${${confName}List})
  ENDIF()

ENDMACRO()

# #################################################################################
# OIV_USE_GTEST (_projName ARGN)
#    Optional second argument let to unflag the test as _CpuUnitTest
#    despite it is based on gtest framemwork

MACRO( OIV_USE_GTEST  _projName )
  if(OIV_DEV_BUILD)
    include_directories("${OivSuite_SOURCE_DIR}/UnitTests/Common/googletest-1.8.1/googletest/include")
    set( GTEST_MAIN_SRC "${OivSuite_SOURCE_DIR}/UnitTests/Common/googletest-1.8.1/googletest/src" )
	include_directories("${OivSuite_SOURCE_DIR}/UnitTests/Common/googletest-1.8.1/googlemock/include")
    set( GMOCK_MAIN_SRC "${OivSuite_SOURCE_DIR}/UnitTests/Common/googletest-1.8.1/googlemock/src" )
  else()
    include_directories("${CMAKE_SOURCE_DIR}/Common/googletest-1.8.1/googletest/include")
    set( GTEST_MAIN_SRC "${CMAKE_SOURCE_DIR}/Common/googletest-1.8.1/googletest/src" )
    include_directories("${CMAKE_SOURCE_DIR}/Common/googletest-1.8.1/googlemock/include")
    set( GMOCK_MAIN_SRC "${CMAKE_SOURCE_DIR}/Common/googletest-1.8.1/googlemock/src" )
  endif()
  if(MSVC)
    target_link_libraries(${_projName} gtest iphlpapi gmock)
  else()
    target_link_libraries(${_projName} gtest gmock)
  endif()
  if( NOT "${ARGN}" STREQUAL "" )
    set(${_projName}_OIV_IS_UNITTEST "${ARGV2}")
  else()
    set(${_projName}_OIV_IS_UNITTEST TRUE)
  endif()
  
ENDMACRO()


# #################################################################################

MACRO(ADD_EBUGTEST_TEST testname0 WorkingSourceDir WorkingOutputDir testExecutable0 ARGN)

  if (OIV_ENABLE_TESTS)


    FILE( TO_CMAKE_PATH "$ENV{ARTHOME}" basePath )
    FILE( TO_CMAKE_PATH $ENV{OIVHOME} oivHome )
    

    STRING(REPLACE "${testExecutable0}" "${WorkingOutputDir}/${testExecutable0}" testExecutable ${testExecutable0} )
    STRING(REGEX REPLACE "(.*)/Ebugs/(.*)" "\\2" EbugsRefExtension ${WorkingSourceDir} )		
    STRING(REPLACE "/Users" "/home" WorkingOutputDir ${WorkingOutputDir} )

    string( REPLACE "${basePath}/" "" ExeFile ${CURRENT_DIRECTORY} )
    set( EBUGS_CTESTS_OUTPUT_PATH "${OIV_TESTS_OUTPUT_PATH}" )

    FILE( TO_CMAKE_PATH ${ARGN} args )
    FILE( TO_CMAKE_PATH ${OIV_TESTS_REFERENCE_PATH}/${EbugsRefExtension}/TestCase refFile )
    
    get_filename_component(refFullPath "${refFile}" PATH)

    get_filename_component(refName "${CMAKE_CURRENT_BINARY_DIR}" NAME)
       
    if (OIV_TESTS_ENABLE_PAGEHEAP)
      set( enablePageHeap "1" )
    else()
      set( enablePageHeap "0" )
    endif()
      
    #Everything should be in TO_CMAKE_PATH but vbs want to have native mode for path with spaces
    FILE( TO_CMAKE_PATH ${testExecutable} testExecutable )
    FILE( TO_CMAKE_PATH ${refFullPath} refFullPath )
    FILE( TO_CMAKE_PATH ${testname0} testname0 )
    FILE( TO_CMAKE_PATH ${EBUGS_CTESTS_OUTPUT_PATH}/${module}/${refName} fullOutputPath )
    FILE( TO_CMAKE_PATH ${WorkingOutputDir} WorkingOutputDir )
    
    set(testConfigs "${OIV_TEST_CONFIGS}")
    
    separate_arguments(testConfigs) 
    foreach(confName ${testConfigs})		
    
      set( confValue "")
      string(REGEX REPLACE " " "" confName "${confName}")
      if(NOT "${confName}" STREQUAL "default")
        file(STRINGS ${oivHome}/../cmake/${confName}.cfg confValue NEWLINE_CONSUME)
      endif()
      
      set( confValue "OIV_TEST_CONF_NAME=${confName} ${confValue}")
      separate_arguments(confValue) 
      set( confValue "OIV_TEST_CONFIGS=\"${OIV_TEST_CONFIGS}\";${confValue}")
      
      set(testNameParam "[${confName}]_${testname0}")
      FILE( TO_CMAKE_PATH "${oivHome}/source/cmake/runUnitTest.py" runUnitTestScript)
      get_filename_component(runUnitTestScript "${runUnitTestScript}" REALPATH)	
      add_test(${testNameParam} ${Python_EXECUTABLE} "-W ignore::DeprecationWarning" "${runUnitTestScript}" "${testExecutable}" "${WorkingOutputDir}" "${refFullPath}" "${testname0}" "${fullOutputPath}" "${GIT_BRANCH_NAME_WITH_PATH}" "${GIT_BRANCH_SHAID}" "\"${OIV_TEST_CONFIGS}\"" "${args}" "${enablePageHeap}")
      
      set_property( TEST ${testNameParam} PROPERTY ENVIRONMENT ${confValue} )			
      set_property( TEST ${testNameParam} PROPERTY LABEL ${confName} )
      
    endforeach()

  endif()

ENDMACRO()
