# tells CMake's `source_group` command to use '/' as a delimiter, grouping files in hierarchies.
set(SOURCE_GROUP_DELIMITER "/")

# outfiles is the list of resulting file to include in output_header
# output_header is the file to include in your code
# ARGN (directory list from which to embed text files with extension .h and .glsl
macro (embed_shader_files outfiles output_header)
  
  SET(output_file "")
  FOREACH (it ${ARGN})
    FILE(GLOB_RECURSE txtFiles "${it}/*.h")
    UTILS_TXTFILE2MAP(output_file "${it}/" "${txtFiles}")
	
	FILE(GLOB_RECURSE glslFiles "${it}/*.glsl")
	UTILS_TXTFILE2MAP(output_file "${it}/" "${glslFiles}")
	
    SET(${outfiles} ${${outfiles}} ${output_file})
  endforeach()

  GET_FILENAME_COMPONENT(namespace ${output_header} NAME_WE)

  #generate the file with a temporary name
  set(temporary_file "${output_header}.tmp")
  set(TMP_CONTENT "/* Auto generated file, please do not modify !              */\n")
  string(APPEND TMP_CONTENT "namespace ${namespace} {\n  void init()\n  {\n")

  FOREACH (it ${${outfiles}})
        string(APPEND TMP_CONTENT "#include \"${it}\"\n")
  ENDFOREACH()
  string(APPEND TMP_CONTENT "  }\n};\n\n")
  FILE(WRITE ${temporary_file} "${TMP_CONTENT}")

  #if required, overwrite the existing file (this avoids rebuilding when no modification occured)
  execute_process(COMMAND ${CMAKE_COMMAND} -E copy_if_different ${temporary_file} ${output_header})

endmacro (embed_shader_files)

macro (embed_filtered_shader_files outfiles filter output_header)
  SET(output_file "")
  STRING(LENGTH "${filter}" filterLength)

  FOREACH (it ${ARGN})
    if (${filterLength})
      FILE(GLOB_RECURSE txtFiles "${it}/${filter}/*.h")
    else()
      FILE(GLOB_RECURSE txtFiles "${it}/*.h")
    endif()

    UTILS_TXTFILE2MAP(output_file "${it}/" "${txtFiles}")

    if (${filterLength})
      FILE(GLOB_RECURSE glslFiles "${it}/${filter}/*.glsl")
    else()
      FILE(GLOB_RECURSE glslFiles "${it}/*.glsl")
    endif()

	  UTILS_TXTFILE2MAP(output_file "${it}/" "${glslFiles}")

    SET(${outfiles} ${${outfiles}} ${output_file})
  endforeach()

  GET_FILENAME_COMPONENT(namespace ${output_header} NAME_WE)
  #generate the file with a temporary name
  set(temporary_file "${output_header}.tmp")
  set(TMP_CONTENT "/* Auto generated file, please do not modify !              */\n")
  string(APPEND TMP_CONTENT "namespace ${namespace} {\n  void init()\n  {\n")
  FOREACH (it ${${outfiles}})
        string(APPEND TMP_CONTENT "#include \"${it}\"\n")
  ENDFOREACH()
  string(APPEND TMP_CONTENT "  }\n};\n\n")
  FILE(WRITE ${temporary_file} "${TMP_CONTENT}")

  #if required, overwrite the existing file (this avoids rebuilding when no modification occured)
  execute_process(COMMAND ${CMAKE_COMMAND} -E copy_if_different ${temporary_file} ${output_header})

endmacro (embed_filtered_shader_files)
