# Detect the version of conan.io and include corresponding version of conan.cmake
function(SET_CONAN_INCLUDE directory)
  find_program(CONAN_COMMAND conan REQUIRED)
  execute_process( COMMAND ${CONAN_COMMAND} --version OUTPUT_VARIABLE conan_version_result )
  message( STATUS "${conan_version_result}" )
  if ( "${conan_version_result}" MATCHES ". 0\\.[0-9]+\\.[0-9]+" )
    include(${directory}/conan_0_30.cmake)
    message( STATUS "Use conan_0_30.cmake" )
  elseif ( "${conan_version_result}" MATCHES ". 1\\.[0-9]+\\.[0-9]+" )
    include(${directory}/conan_1_x.cmake)
    message( STATUS "Use conan_1_x.cmake" )
  else()
    message( FATAL_ERROR "Cannot identify the conan.io version with ${conan_version_result}" )
  endif()
endfunction()
