#coding: utf-8
import re
import sys
import os
import errno


def removeComments(string):
    # remove block comments (/* COMMENT */)
    string = re.sub(re.compile(r"/\*.*?\*/", re.DOTALL), "", str(string.decode()))
    # remove singleline comments (// COMMENT ), but not OIV-keywords (prefixed by //!)
    string = re.sub(re.compile(r"//(\n|([^\!].*))"), "", string)
    return string


def removeEmptyLines(string):
    text = "\n".join([ll.rstrip() for ll in string.splitlines() if ll.strip()])
    return text


def removeExtraSpaces(string):
    text = " ".join(string.split())
    return text


def replaceSpecialCharacters(string):
    string = re.sub("\"", "\\\"", string)
    return string


def mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else:
            raise


###############################################################################

# arguments must be:
# 1) the name of the shader
# 2) the filename of the input shader file
# 3) the filename of the output inc file
narg = len(sys.argv)
if narg != 4:
    print("parseShaderFile: Needs 4 arguments ({})".format(narg))
    sys.exit(1)

name = sys.argv[1]
ifilename = sys.argv[2]
ofilename = sys.argv[3]

# open input file
ifile = open(ifilename, 'rb')

# read input file
ifilestr = ifile.read()

# close input file
ifile.close()

# parse input file
ifilestr = removeComments(ifilestr)
ifilestr = removeEmptyLines(ifilestr)
ifilestr = replaceSpecialCharacters(ifilestr)

# create directory
p = os.path.dirname(ofilename)
if not os.path.isdir(p):
    mkdir_p(p)

# write output file
ofile = open(ofilename, 'w')
ofile.write("/* Auto generated file, please do not modify ! */\n")
ofile.write("SoInput::addInMemoryTextFile(\"")
ofile.write(name)
ofile.write("\", \n")
lines = ifilestr.splitlines()
for line in lines:
    ofile.write("\"")
    ofile.write(removeExtraSpaces(line))
    ofile.write("\\n\"\n")
ofile.write(");\n")
ofile.close()
