import sys
import os
import locale
import glob
import oiv_common

# ---------------------------------------------------------------------------------------
#                                   FUNCTIONS
# ---------------------------------------------------------------------------------------

def compareImages(dir, testName, oivTestConfsList, oivTestConfName, referencesDir):
    print("PNG Files found in " + dir)
    returnCode = 0
    for i in glob.glob(dir  + "/*.png"):
        isTested = True
        i = str.replace(i, "\\", "/")
        print("Find some. Searching for " + testName + " in " + i)
        if i.find("montage") == -1 and i.find("diff") == -1 and i.find(testName) != -1:

            filename = os.path.basename(i)

            for isPrefixed in oivTestConfsList:
                if filename.find(isPrefixed) != -1:
                    isTested = False

            if isTested == True:
                filename = oivTestConfName + filename
                filename = dir + "/" + filename
                if (oiv_common.file_exists(filename) and i != filename):
                    os.remove(filename)
                os.rename(i, filename)
                returnCode = returnCode + oiv_common.compareImage(filename, dir, referencesDir, oivTestConfName)
    return returnCode

# ---------------------------------------------------------------------------------------
#                                   MAIN
# ---------------------------------------------------------------------------------------

executable = sys.argv[1]
print("executable: " + executable)
outputDir = sys.argv[2]
print("outputDir: " + outputDir)
referencesDir = sys.argv[3]
print("referencesDir: " + referencesDir)
testName = sys.argv[4]
print("testName: " + testName)
resultDir = sys.argv[5]
print("resultDir: " + resultDir)
branch_name = sys.argv[6]
print("branch_name: " + branch_name)
gitSha = sys.argv[7]
oivTestConfsList = sys.argv[8]
print("oivTestConfsList: " + oivTestConfsList)
testParam = sys.argv[9]
print("testParam: " + testParam)

#-----------------------------------------------
# Specific Environement variables
#-----------------------------------------------
os.environ["OIV_MAINLOOP_KEEP_EXCEPTION"] = "1"

#-----------------------------------------------
# 1 - Run art and check the result
#-----------------------------------------------

# define the warning and error level as a percent of result difference for output bench.
# 2% leads to warning. The bench is marked as PASSED
warnLimit = 10
# 4% leads to error. The bench is marked as FAILED
errorLimit = 20

locale.setlocale(locale.LC_ALL, 'C')
if not os.path.exists(resultDir):
    os.makedirs(resultDir)

testParam = str.replace(testParam, ";", " ")
testName = str.replace(testName, ":", "_")
exitCode = oiv_common.getProgramStandardOutput(executable + " " + testParam, resultDir + "/" + testName + "_stdout.log", resultDir + "/" + testName + "_stderr.log")

#-----------------------------------------------------
# 1.5 - Set cdash server and branch name
#-----------------------------------------------------
oiv_common.setBranchName(branch_name)
oiv_common.setCdashServer("frbor-cdash01/api/v1")
oiv_common.dartOutputCommitButton(referencesDir)

if os.path.isdir(resultDir) == False:
    print("Error: Directories don't exist.")
    exitCode = 1
else:
    #-----------------------------------------------
    # 2 - Compare the images
    #-----------------------------------------------

    oivTestConfName = os.getenv("OIV_TEST_CONF_NAME", "default")

    if oivTestConfName == "default":
        oivTestConfName = ""
    else:
        oivTestConfName = oivTestConfName + "_"

    oivTestConfsList = str.replace(oivTestConfsList, "\"", "")
    oivTestConfsList = str.split(oivTestConfsList)

    # Search images in resultDir
    if len(glob.glob(resultDir + "/*.png")) > 0:
        returnCode = compareImages(resultDir, testName, oivTestConfsList, oivTestConfName, referencesDir)
        if returnCode != 0:
            exitCode = returnCode
    # References exists, but no generated png found
    elif len(glob.glob(referencesDir + "/*" + testName + "*.png")) > 0:
        print("Error: Reference found but no generated image in : " + resultDir)
        exitCode = 1

    #-----------------------------------------------
    # 3 - Compare the outputs
    #-----------------------------------------------

    testNameWithConf = oivTestConfName + testName
    if oivTestConfName != "":
        if oiv_common.file_exists(resultDir + "/" + testNameWithConf + "_stdout.log"):
            os.remove(resultDir + "/" + testNameWithConf + "_stdout.log")
        if oiv_common.file_exists(resultDir + "/" + testNameWithConf + "_stderr.log"):
            os.remove(resultDir + "/" + testNameWithConf + "_stderr.log")

    if oiv_common.file_exists(resultDir + "/" + testName + "_stdout.log"):
        os.rename(resultDir + "/" + testName + "_stdout.log", resultDir + "/" + testNameWithConf + "_stdout.log")
    if oiv_common.file_exists(resultDir + "/" + testName + "_stderr.log"):
        os.rename(resultDir + "/" + testName + "_stderr.log", resultDir + "/" + testNameWithConf + "_stderr.log")

    returnCode = oiv_common.compareOutput(testName, resultDir, referencesDir, warnLimit, errorLimit, oivTestConfName)
    if returnCode == 1:
        exitCode = 1

#-----------------------------------------------
# End of Main function
#-----------------------------------------------
oiv_common.dartOutputGitSha(gitSha)
#Print the environment and the OIV_CONFIG_FILE
oiv_common.dartOutputEnv()
if "OIV_CONFIG_FILE" in os.environ:
    configFile = os.getenv("OIV_CONFIG_FILE", "oiv.cfg")
    if os.path.exists(configFile):
        oiv_common.dartOutputFileExpand("OivConfig", configFile)

print("exitcode: " + str(exitCode))
sys.exit(exitCode)
