/*--------------------------------------------------------------
 *  Similar to Inventor Mentor example 02.4.Examiner.cxx
 *
 *  Use an Examiner Viewer to look at a red cone
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>

int
main(int, char **argv)
{
  // Window
  Widget window = SoXt::init(argv[0]);
  if (window == NULL)
    exit(1);
  
  // Scenegraph
  SoRef<SoSeparator> root = new SoSeparator();

  SoPerspectiveCamera* camera = new SoPerspectiveCamera();
    root->addChild(camera);
  
  SoMaterial* material = new SoMaterial();
    material->diffuseColor.setValue(1.0, 0.0, 0.0);
    root->addChild(material);

  SoCone* geometry = new SoCone();
    root->addChild(geometry);

  // Viewer
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(window);
  viewer->setTitle("Hello Cone!");
  viewer->setSceneGraph(root.ptr());
  viewer->viewAll();
  viewer->saveHomePosition();
  viewer->show();
  
  // Execute
  SoXt::show(window);
  SoXt::mainLoop();
  delete viewer;
  root = NULL;
  SoXt::finish();
  return 0;
}



