//!oiv_include <Inventor/oivShaderState.h>

//!oiv_include <Inventor/oivDepthPeeling_frag.h>
/* !!GLSL */

in float diffuseLight;
in float specularLight;
in float edge;
in vec4 diffuseColor;
in vec4 specularColor;

// We don't need that uniform to be given by the API.
// By default, uniform are initialised to 0. It's what we want here.
uniform sampler2D ramp;

void main()
{
  // Create the texCoords  
  vec2 texCoordDiffuse  = vec2(diffuseLight, 0);
  vec2 texCoordSpecular = vec2(specularLight, 0);
  vec2 texCoordEdge     = vec2(edge, 0);

  // Apply the step function
  float diffLight  = texture(ramp, texCoordDiffuse).x;
  float specLight  = texture(ramp, texCoordSpecular).x;
  float edgeL      = texture(ramp, texCoordEdge).x;

  // Compute the final color
  vec4 color   = edgeL * (diffuseColor*diffLight + specularColor*specLight);
  color.w = 1.0;
  OivDepthPeelingOutputColor(color);
} 
