//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

/* !!GLSL */

uniform vec3 lightDirection;

out float  diffuseLight;
out float  specularLight;
out float  edge;
out vec4 diffuseColor;
out vec4 specularColor;

out vec3 diff;

void main()
{
  OivInitVertexData();

  // Retreives diffuse and specular color from the OpenGL state
  diffuseColor   = OivFrontMaterialDiffuse();
  specularColor  = OivFrontMaterialSpecular();

  // Set the output position of the vertex 
  gl_Position = OivModelViewProjectionMatrix() * OivVertexPosition();

  // Transform the position and normal in eye space
  vec4 tmpGlVertex = OivModelViewMatrix() * OivVertexPosition();
  vec3 tmpGlNormal = OivNormalMatrix() * OivVertexNormal();

  // Calculate the diffuse lighting
  vec3 N       = normalize(tmpGlNormal);
  diffuseLight = max(dot(N, lightDirection), 0.);

  // Calculate the specular lighting
  vec3 V      = normalize(-tmpGlVertex.xyz);
  vec3 H      = normalize(lightDirection + V);
  specularLight = pow(max(dot(N, H), 0.), OivFrontMaterialShininess());
  if(diffuseLight <= 0.) 
    specularLight = 0.;
  if(OivFrontMaterialShininess() ==0.0)
    specularLight = 0.9;

  // Perform edge detection
  edge = max(dot(N, V), 0.);
} 
