#version 410 core

//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

#extension GL_EXT_geometry_shader4 : enable

layout (points) in;
layout (triangle_strip, max_vertices = 24) out;
uniform float BarWidth;

in vec4 colorVtx[];

out vec4 color;

/******************************************************************************/
// Compute the diffuse color according to the normal.
vec4
computeDiffuseColor( vec3 normal )
{
  vec3 tNormal = normalize( OivNormalMatrix() * normal );
  return ( max( dot( tNormal, vec3( OivLightSourcePosition(0) ) ), 0. ) * colorVtx[0] );
}/******************************************************************************/

void main(void)
{
  vec4 posIn = gl_PositionIn[0];
  vec4 position;
  position.w = posIn.w;

  vec4 color1 = computeDiffuseColor( vec3( 0, -1, 0 ) );
  vec4 color2 = computeDiffuseColor( vec3( 1, 0, 0 ) );
  vec4 color3 = computeDiffuseColor( vec3( 0, 1, 0 ) );
  vec4 color4 = computeDiffuseColor( vec3( -1, 0, 0 ) );
  vec4 color5 = computeDiffuseColor( vec3( 0, 0, 1 ) );
  vec4 color6 = computeDiffuseColor( vec3( 0, 0, -1 ) );

  // 1st face
  OivSetupVertex(0);
  position.x = posIn.x - BarWidth;
  position.y = posIn.y - BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color1;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color1;
  EmitVertex();
  
  OivSetupVertex(0);
  position.x = posIn.x + BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color1;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color1;
  EmitVertex();
  EndPrimitive();
  
  // 2nd face
  OivSetupVertex(0);
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color2;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color2;
  EmitVertex();
  
  OivSetupVertex(0);
  position.y = posIn.y + BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color2;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color2;
  EmitVertex();
  EndPrimitive();
  
  // 3rd face
  OivSetupVertex(0);
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color3;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color3;
  EmitVertex();
  
  OivSetupVertex(0);
  position.x = posIn.x - BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color3;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color3;
  EmitVertex();
  EndPrimitive();
  
  // 4th face
  OivSetupVertex(0);
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color4;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color4;
  EmitVertex();
      
  OivSetupVertex(0);
  position.y = posIn.y - BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color4;
  EmitVertex();
  
  OivSetupVertex(0);
  position.z = posIn.z;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color4;
  EmitVertex();
  EndPrimitive();
  
  // 5th face
  OivSetupVertex(0);
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color5;
  EmitVertex();
  
  OivSetupVertex(0);
  position.y = posIn.y + BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color5;
  EmitVertex();
  
  OivSetupVertex(0);
  position.x = posIn.x + BarWidth;
  position.y = posIn.y - BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color5;
  EmitVertex();
  
  OivSetupVertex(0);
  position.y =  posIn.y + BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color5;
  EmitVertex();
  EndPrimitive();
  
  // 6th face
  OivSetupVertex(0);
  position.x = posIn.x - BarWidth;
  position.y = posIn.y - BarWidth;
  position.z = 0.0;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color6;
  EmitVertex();
  
  OivSetupVertex(0);
  position.y = posIn.y + BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color6;
  EmitVertex();
  
  OivSetupVertex(0);
  position.x = posIn.x + BarWidth;
  position.y = posIn.y - BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color6;
  EmitVertex();
  
  OivSetupVertex(0);
  position.y =  posIn.y + BarWidth;
  gl_Position = OivModelViewProjectionMatrix() * position;
  color = color6;
  EmitVertex();
  EndPrimitive();	  
}/******************************************************************************/

