/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (Oct 2010)
**=======================================================================*/

#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/SoWinApp.h>

#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>

SoSeparator* readFile( const SbString& filename )
{
  // Open the input file
  SoInput mySceneInput;
  if ( !mySceneInput.openFile(filename) ) 
  {
    fprintf( stderr, "Cannot open file %s\n", filename.toLatin1() );
    return NULL;
  }
  
  // Read the whole file into the database
  SoSeparator* myGraph = SoDB::readAll( &mySceneInput );
  if ( myGraph == NULL ) 
  {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 
  
  mySceneInput.closeFile();
  return myGraph;
}

int main(int, char **argv)
{
  SoPreferences::setBool("OIV_ENABLE_CONTEXT_SHARING", FALSE);
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init( argv[0] );

  SoDialogViz::init();
 

  SoTopLevelDialog *myTopLevelDialog = (SoTopLevelDialog *)SoDialogViz::loadFromFile("$OIVHOME/examples/source/DialogViz/2D/multiViewers/multiViewers.iv");
  myTopLevelDialog->buildDialog( myWindow, TRUE);
  
  SoSeparator* scene = readFile( "$OIVHOME/data/models/torus.iv" );
  SoDialogCustom* dialogCustom1 = (SoDialogCustom*)myTopLevelDialog->searchForAuditorId( "viewer1" );
  SoXtExaminerViewer* viewer1 = new SoXtExaminerViewer( dialogCustom1->getWidget() );
  viewer1->setSceneGraph( scene );
  viewer1->show();
  
  scene = readFile( "$OIVHOME/data/models/moon.iv" );
  SoDialogCustom* dialogCustom2 = (SoDialogCustom*)myTopLevelDialog->searchForAuditorId( "viewer2" );
  SoXtExaminerViewer* viewer2 = new SoXtExaminerViewer( dialogCustom2->getWidget() );
  viewer2->setSceneGraph( scene );
  viewer2->show();

  scene = readFile( "$OIVHOME/data/models/star.iv" );
  SoDialogCustom* dialogCustom3 = (SoDialogCustom*)myTopLevelDialog->searchForAuditorId( "viewer3" );
  SoXtPlaneViewer* viewer3 = new SoXtPlaneViewer( dialogCustom3->getWidget() );
  viewer3->setSceneGraph( scene );
  viewer3->show();

  myTopLevelDialog->show();

  // main loop
  SoXt::show(myWindow);
  SoXt::mainLoop();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


