
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <DialogViz/SoDialogVizAll.h>

#include <Inventor/SoWinApp.h>


SoText3* myText;
SoXtExaminerViewer* myViewer;
SoBaseColor* myColor;

class TextAuditor : public SoDialogEditTextAuditor
{
public:
  void dialogEditText(SoDialogEditText* /*pb*/) { ; }
};
class ButtonAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton(SoDialogPushButton* /*pb*/) { exit(1); }
};

class SliderAuditor : public SoDialogRealSliderAuditor
{
public:
  void dialogRealSlider(SoDialogRealSlider* rs) {
    const float value[][3] = {{rs->value.getValue(), 1, 1}};
    myColor->rgb.setHSVValues(0, 1, value);
  }
};

int
main(int, char **argv)
{
  // Initialize Inventor and DialogViz
  Widget myWindow = SoXt::init( argv[0] );
  SoDialogViz::init();

  SoSeparator* root = new SoSeparator;
  root->ref();
  
  myColor = new SoBaseColor;
  myColor->rgb.setValue(1,0,0);
  root->addChild(myColor);

  myText = new SoText3;
  myText->parts = SoText3::ALL;
  root->addChild(myText);

  myViewer = new SoXtExaminerViewer(myWindow);

  SoTopLevelDialog* myDialog = new SoTopLevelDialog;
  
  
  SoDialogEditText* myEdit = new SoDialogEditText;
  myEdit->label = "My text : ";
  myEdit->width = 200;
  myEdit->trigOnEnter = FALSE;
  myEdit->addAuditor(new TextAuditor());

  myDialog->addChild(myEdit);
  myEdit->editText = "my Text";
  myText->string.connectFrom(&myEdit->editText);

  const SbColor color[8] = { SbColor(1,0,0), SbColor(1,1,0), SbColor(1,1,0),
                             SbColor(0,1,0), SbColor(0,1,1), SbColor(0,0,1),
                             SbColor(1,0,1), SbColor(1,0,0)};
  SoDialogRealSlider* mySlider = new SoDialogRealSlider;
  mySlider->label = "Color : ";
  mySlider->colors.setValues(0,8, color);
  mySlider->addAuditor(new SliderAuditor());
  myDialog->addChild(mySlider);

  SoDialogPushButton* myButton = new SoDialogPushButton;
  myButton->buttonLabel = "Quit";
  myButton->addAuditor(new ButtonAuditor());
  myDialog->addChild(myButton);

  myDialog->buildDialog( myWindow, FALSE );
  myDialog->show();

  myViewer->setSceneGraph(root);
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  myDialog->close();
  root->unref();
  delete myViewer;

  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


