#include <Inventor/Xt/SoXt.h>
#include <Inventor/SoWinApp.h>

#include <DialogViz/SoDialogVizAll.h>

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init( argv[0] );

  SoDialogViz::init();
 
  // Read the geometry from a file and add to the scene
  SoInput myInput;
  if (!myInput.openFile( "$OIVHOME/examples/source/DialogViz/2D/showAll/showAll.iv" ))
    exit (1);
  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (myGroup == NULL)
    exit (1);

  SoTopLevelDialog *myTopLevelDialog = nullptr;
  // Build and show all the dialogs described under myGroup
  for (int i = 0; i < myGroup->getNumChildren(); i++) {
    myTopLevelDialog = (SoTopLevelDialog *)myGroup->getChild( i );
    myTopLevelDialog->buildDialog( myWindow, i==0 );
    myTopLevelDialog->show();
  }

  SoXt::show(myWindow);
  SoXt::mainLoop();

  if ( myTopLevelDialog != nullptr )
  {
    myTopLevelDialog->close();
  }

  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


