/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/SoWinApp.h>

#include <DialogViz/dialog/SoDialogCustom.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoDialogComboBox.h>
#include <DialogViz/dialog/SoDialogRadioButtons.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoMenuBar.h>
#include <DialogViz/dialog/SoMenuPopup.h>
#include <DialogViz/dialog/SoColumnDialog.h>
#include <DialogViz/auditors/SoDialogChoiceAuditor.h>

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoTranslation.h>

class ChangeSkinCombo : public SoDialogChoiceAuditor
{
  void dialogChoice(SoDialogChoice* dc) {
    switch (dc->selectedItem.getValue()) {
    case 0:
      SoDialogViz::setSkin("default");
      break;
    case 1:
      SoDialogViz::setSkin("texture");
      break;
    case 2:
      SoDialogViz::setSkin("transparent");
      break;
    }
  }
};

SoSeparator *scene3D;
SoPerspectiveCamera* Camera;


class PoXtExaminerViewer : public SoXtExaminerViewer
{
public:
  PoXtExaminerViewer(Widget parent, const char *name,
				       SbBool buildInsideParent, 
				       SoXtFullViewer::BuildFlag flag=BUILD_ALL,
               SoXtViewer::Type type=BROWSER );
  virtual void viewAll();
};

PoXtExaminerViewer::PoXtExaminerViewer(Widget parent, const char *name,
				       SbBool buildInsideParent, 
				       SoXtFullViewer::BuildFlag flag,
				       SoXtViewer::Type typeViewer) :
  SoXtExaminerViewer(parent, name, buildInsideParent, flag,
		     typeViewer)
{

}

void
PoXtExaminerViewer::viewAll()
{
  Camera->viewAll(scene3D, SbViewportRegion(100, 100)) ;
}

/* MAIN PROGRAM */
int
main(int argc, char **argv){

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
	
  SoDialogViz::init();
  SoDialogViz::setSkin("transparent");
	
  SbString dialogIvFile = "$OIVHOME/examples/source/DialogViz/3D/setSkin/setSkin.iv";
  SoTopLevelDialog* myTopLevelDialog = (SoTopLevelDialog*)SoDialogViz::loadFromFile(dialogIvFile);
  myTopLevelDialog->position3D.setValue(10, -20, 0);

  SoSeparator *root = new SoSeparator ;
  root->ref() ;
	
  /* BUILS MAIN SCENE */
  SoInput myInput;
  SbString ivFile ;
  if (argc > 1) {
    ivFile = argv[1];
  }
  else {
    ivFile = "$OIVHOME/data/models/chair.iv";
  }
  if (!myInput.openFile(ivFile.getString())) 
    exit (1);
  SoSeparator* SceneSep = SoDB::readAll(&myInput);
  if (SceneSep == NULL) 
    exit (1);

	Camera = new SoPerspectiveCamera ;

	SoPerspectiveCamera *cameraMenu = new SoPerspectiveCamera;
	cameraMenu->viewAll(myTopLevelDialog, SbViewportRegion(100, 100));
	cameraMenu->position = cameraMenu->position.getValue() + SbVec3f(60,-60,0) ;

	SoSeparator *allMenu = new SoSeparator;
	SoScale *scale = new SoScale;
	scale->scaleFactor.setValue(0.5,0.5,0.5);
	SoDirectionalLight *light = new SoDirectionalLight;

	allMenu->addChild(cameraMenu);
	allMenu->addChild(light);
	allMenu->addChild(scale);
	allMenu->addChild(myTopLevelDialog);

	SoSeparator *sep = new SoSeparator;
	sep->addChild(SceneSep);

	// Build the scene graph
	scene3D = new SoSeparator ;
	SoPickStyle *pickStyle =new SoPickStyle;
	pickStyle->style = SoPickStyle::UNPICKABLE;

	scene3D->addChild(pickStyle) ;
	scene3D->addChild(Camera) ;
	scene3D->addChild(sep);
	
	root->addChild(scene3D) ;
	root->addChild(allMenu);

/* BUILD USER INTERFACE*/
  SoTopLevelDialog* mainDialog = new SoTopLevelDialog;
  mainDialog->label = "Set Skin Demo" ;

  SoColumnDialog* col = new SoColumnDialog;
  SoDialogCustom* custom = new SoDialogCustom;
  custom->width = 800;
  custom->height = 600;
  col->addChild(custom);
  SoDialogRadioButtons* combo = new SoDialogRadioButtons;
  combo->label = "Skin :";
  combo->selectedItem = 2 ;
  combo->addItem("default");
  combo->addItem("texture");
  combo->addItem("transparent");
  combo->fixedWidth = TRUE;
  combo->maxHeight = 100;
  combo->addAuditor(new ChangeSkinCombo);
  col->addChild(combo);
  mainDialog->addChild(col);
  mainDialog->buildDialog(myWindow, TRUE);

  PoXtExaminerViewer* PViewer = new PoXtExaminerViewer(custom->getWidget(), "", TRUE);
 	PViewer->setTransparencyType(SoGLRenderAction::NO_SORT);

	// Attach and show viewer
	PViewer->setSceneGraph(root);
	PViewer->setHeadlight(TRUE);
	PViewer->setBackgroundColor(SbColor(0.2f,0.2f,0.7f)) ;
	PViewer->show();
	PViewer->setViewing(FALSE);
	PViewer->viewAll();

	// Loop forever
	SoXt::show(myWindow);
	SoXt::mainLoop();
    SoDialogViz::finish();
	SoXt::finish();
	
	return 0;
}


