#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <HardCopy/SoVectorizePSAction.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/helpers/SbFileHelper.h>

#include "utils.h"

SoSeparator* g_root = NULL;

/*********************************************************************************/
void exportSceneGraphToPSFile(const SbString& outputFilePath, int borderSize, SoVectorizeAction::Orientation orientationMode)
{
  // Create and apply the PostScript action.
  SoVectorizePSAction vect;

  vect.setOrientation( orientationMode );
  vect.setBorder( float(borderSize) );

  vect.getPSVectorOutput()->openFile( outputFilePath );
  vect.apply( g_root );
  vect.getPSVectorOutput()->closeFile();
}

/*********************************************************************************/
class InterfaceAuditor : public SoDialogAuditor
{
public:
  InterfaceAuditor( SoTopLevelDialog* topDialog )
  {
    m_top = topDialog;
  }

private:
  SoTopLevelDialog* m_top;

  void dialogPushButton( SoDialogPushButton* cpt )
  {
    if ( cpt->auditorID.getValue() == "pushButton_export" )
    {
      SoDialogEditText* outputFilePathDialog = (SoDialogEditText*)(m_top->searchForAuditorId( "outputFilePath" ));
      SoDialogIntegerSlider* borderSizeDialog = (SoDialogIntegerSlider*)(m_top->searchForAuditorId( "borderSize" ));
      SoDialogComboBox* orientationModeDialog = (SoDialogComboBox*)(m_top->searchForAuditorId( "orientationMode" ));

      exportSceneGraphToPSFile(
        outputFilePathDialog->editText.getValue(),
        borderSizeDialog->value.getValue(),
        SoVectorizeAction::Orientation(orientationModeDialog->selectedItem.getValue()) );
    }
  }
};

/*********************************************************************************/
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init( argv[0] );
  if ( myWindow == NULL )
    return 0;

  SoHardCopy::init();
  SoDialogViz::init();

  // Create the root of the scene graph
  g_root = new SoSeparator;
  g_root->ref();
  
  // Create the Camera node
  SoPerspectiveCamera* myCam = new SoPerspectiveCamera;
  g_root->addChild(myCam);

  // Use wireframe draw style
  SoDrawStyle* drawStyle = new SoDrawStyle;
  drawStyle->style = SoDrawStyle::LINES;
  g_root->addChild(drawStyle);

  // Create a simple sphere
  SoSphere* shape = new SoSphere;
  g_root->addChild(shape);

  SoTopLevelDialog* myTopLevelDialog;
  SbString interfaceFile = SbFileHelper::expandString( "$OIVHOME/examples/source/HardCopy/Mentor/interface_tutorial01.iv" );
  Widget parent = buildInterface( myWindow, interfaceFile.toLatin1(), "Viewer", &myTopLevelDialog );
  InterfaceAuditor* myInterfaceAuditor = new InterfaceAuditor( myTopLevelDialog );
  myTopLevelDialog->addAuditor( myInterfaceAuditor );

  // Update filePath to currentDirectory
  SoDialogEditText* outputFilePathDialog = (SoDialogEditText*)(myTopLevelDialog->searchForAuditorId("outputFilePath"));
  if ( outputFilePathDialog != NULL )
  {
    SbString outputFilePath = SbFileHelper::toUnixPath( SbFileHelper::getCurrentDirectory() ) + SbString("/myFile.ps");
    outputFilePathDialog->editText.setValue( outputFilePath );
  }

  SoXtPlaneViewer* viewer = new SoXtPlaneViewer(parent);

  myCam->viewAll( g_root, viewer->getViewportRegion() );
  
  viewer->setSceneGraph(g_root);
  viewer->setTitle("HardCopy tutorial 01");
  viewer->setBackgroundColor( SbColor(1., 1., 1.) );
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  g_root->unref();
  SoDialogViz::finish();
  SoHardCopy::finish();
  SoXt::finish();
  return 0;
}


