#include <Inventor/SoDB.h>
#include <Inventor/nodekits/SoNodeKit.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <HardCopy/SoVectorizePSAction.h>

#include <Inventor/SoWinApp.h>
int
main(int, char **)
{
  // Initialize HardCopy
  SoHardCopy::init();

  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

  // Create the Camera node
  SoPerspectiveCamera *myCam = new SoPerspectiveCamera;
  root->addChild(myCam);

  // Use wireframe draw style
  SoDrawStyle *drawStyle = new SoDrawStyle;
  drawStyle->style = SoDrawStyle::LINES;
  root->addChild(drawStyle) ;

  // Create a simple sphere
  SoSphere *shape = new SoSphere;
  root->addChild(shape) ;

  myCam->viewAll(root, SbViewportRegion(1000, 1000));

  // Create and apply the PostScript action.
  SoVectorizePSAction vect;

  vect.setStartPosition(0,0);
  vect.setDrawingDimensions(80, 80);
  vect.setOrientation(SoVectorizeAction::PORTRAIT);
  vect.setBorder(1.);
  vect.setColorTranslationMethod(SoVectorizeAction::REVERSE_ONLY_BLACK_AND_WHITE );
  vect.setLineEndStyle(SoVectorizeAction::BUTT_END);
  vect.setLineJoinsStyle(SoVectorizeAction::ROUNDED_JOIN);
  vect.setMiterLimit(2.);
  vect.setNominalWidth(0.05f);

  vect.getPSVectorOutput()->openFile("HardCopyOutput.ps");
  vect.apply(root);
  vect.getPSVectorOutput()->closeFile();

  SoHardCopy::finish();
  return 0;
}


