#include <Inventor/SoDB.h>
#include <Inventor/nodekits/SoNodeKit.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <HardCopy/SoVectorizeHPGLAction.h>

#include <Inventor/SoWinApp.h>
int
main(int, char **)
{
  // Initialize HardCopy
  SoHardCopy::init();
  
  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

  // Create the Camera node
  SoPerspectiveCamera *myCam = new SoPerspectiveCamera;
  root->addChild(myCam);
  
  // Use wireframe draw style
  SoDrawStyle *drawStyle = new SoDrawStyle;
  drawStyle->style = SoDrawStyle::LINES;
  root->addChild(drawStyle) ;

  // Create a simple sphere
  SoSphere *shape = new SoSphere;
  root->addChild(shape) ;

  myCam->viewAll(root, SbViewportRegion(1000, 1000));

  // Create and apply the HPGL action.
  SoVectorizeHPGLAction vect;
  
  vect.setStartPosition(10,20);
  vect.setDrawingDimensions(130,100);
  vect.setOrientation(SoVectorizeAction::PORTRAIT);
  // Black and white.
  vect.setPenDescription(2);
  // width = 0.35mm.
  vect.setBorder(1.,SbVec3f( 0., 0., 0. ));
  vect.setBackgroundColor(TRUE, SbVec3f(1., 1., 1.));
  vect.setColorTranslationMethod(SoVectorizeAction::AS_IS);
  vect.setLineEndStyle(SoVectorizeAction::BUTT_END);
  vect.setLineJoinsStyle(SoVectorizeAction::ROUNDED_JOIN);
  vect.setMiterLimit(2.);
  
  vect.getHPGLVectorOutput()->openFile("HardCopyOutput.hpgl");
  vect.apply(root);
  vect.getHPGLVectorOutput()->closeFile();

  SoHardCopy::finish();
  return 0;
}


