#include <Inventor/SoDB.h>
#include <Inventor/nodekits/SoNodeKit.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <HardCopy/SoVectorizeCGMAction.h>

#include <Inventor/SoWinApp.h>
int
main(int, char **)
{
  // Initialize HardCopy
  SoHardCopy::init();
  
  // Create the root of the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref() ;

  // Create the Camera node
  SoPerspectiveCamera *myCam = new SoPerspectiveCamera;
  root->addChild(myCam);
  
  // Use wireframe draw style
  SoDrawStyle *drawStyle = new SoDrawStyle;
  drawStyle->style = SoDrawStyle::LINES;
  root->addChild(drawStyle) ;

  // Create a simple sphere
  SoSphere *shape = new SoSphere;
  root->addChild(shape) ;

  myCam->viewAll(root, SbViewportRegion(1000, 1000));

  // Create and apply the CGM action.
  SoVectorizeCGMAction vect;

  vect.setStartPosition(10,20);
  vect.setDrawingDimensions(130, 100);
  vect.setBorder(1.);
  vect.setBackgroundColor(TRUE);
  // Black and White are reversed !
  vect.setColorTranslationMethod( SoVectorizeAction::REVERSE_ONLY_BLACK_AND_WHITE );
  // Version 1, Clear Text and RGB.
  vect.getCGMVectorOutput()->setVersion(1);
  vect.getCGMVectorOutput()->setIndexed(FALSE);

  vect.getCGMVectorOutput()->openFile("HardCopyOutput.cgm");
  vect.apply(root);
  vect.getCGMVectorOutput()->closeFile();

  SoHardCopy::finish();
  return 0;
}


