
#include <Inventor/SoDB.h>
#include <Inventor/nodekits/SoNodeKit.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/Qt/SoQt.h>
#include <Inventor/Qt/SbQtHelper.h>
#include <MeshViz/PoMeshViz.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <HardCopy/SoHardCopy.h>

#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>
#include <HardCopy/SoToU3DAction.h>
#include <HardCopy/SoToPDFAction.h>


#include "PdfExportDialog.h"

//-----------------------------------------------------------------------------
int main(int argc,char** argv)
{
  SoDB::init();
  SoNodeKit::init();
  SoInteraction::init();
  PoMeshViz::init();
  SoVolumeRendering::init();
  SoHardCopy::init();

  if (argc==1)
  {
    SbQtHelper::addPlatformPluginsPath();
    QApplication app(argc, argv);
    PdfExportDialog* dialog = new PdfExportDialog;
    return dialog->exec();
  }
  else
  {
    SoSeparator* root = NULL;
    if ( !strcmp(argv[1], "-help") || (argc > 4) )
    {
      printf("Usage: oivtopdf <inputFile.iv> [outputFile.pdf] [landscape]\n");
      system("PAUSE");
      return 0;
    }

    try
    {
      QString ivFile = argv[1];
      SoInput input;
      if ( !input.openFile(ivFile.toLocal8Bit().data()) )
        throw QString("Can not open file " + ivFile);
      root = SoDB::readAll( &input );
      input.closeFile();
      if ( !root )
        throw QString("Can not read file " + ivFile);
      root->ref();
   
      QString pdfFile = argc>2 ? QString(argv[2]) : QString(ivFile) + ".pdf";
      bool landscape = false;
      if ( argc == 4 )
      {
        if ( !strcmp(argv[3], "landscape") )
          landscape = true;
      }
      SoToPDFAction pdfAction;
      bool result = pdfAction.openFile(pdfFile.toLocal8Bit().data());
      if ( !result )
        throw QString("Can not open file " + pdfFile);
      pdfAction.setLandscape( landscape );
      pdfAction.apply( root );
      result = pdfAction.closeFile();
      if ( !result )
        throw QString("PDF export failed.");

    }
    catch ( QString err )
    {
      printf("Error: %s\n", err.toLocal8Bit().data());
    }

    if ( root )
      root->unref();

    SoDB::finish();
    SoNodeKit::finish();
    SoInteraction::finish();
    PoMeshViz::finish();
    SoVolumeRendering::finish();
    SoHardCopy::finish();

    return 0; 
  }
}


