/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/

#include <Xm/Form.h>
#include <Inventor/SoDB.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoWWWInline.h>

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Prints usage message.
//

static void
printUsage(const char *progName)
  //
  ////////////////////////////////////////////////////////////////////////
{
  fprintf(stderr, "Usage: %s datafile\n", progName);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Creates and returns a plane viewer with the given name that
//    views along the given direction. The viewer will have an
//    orthographic camera and no decoration.
//

static SoXtPlaneViewer *
createPlaneViewer(Widget parent, const char *name, SoNode *sceneRoot,
		  const SbVec3f &viewDirection)
  //
  ////////////////////////////////////////////////////////////////////////
{
  SoXtPlaneViewer *viewer;

  viewer = new SoXtPlaneViewer(parent, name);

  viewer->setCameraType(SoOrthographicCamera::getClassTypeId());
  viewer->setDecoration(FALSE);
  viewer->setSceneGraph(sceneRoot);

  // Specify the camera's orientation to change the view from
  // looking along the negative z axis to look along the given
  // direction
  viewer->getCamera()->orientation =
    SbRotation(SbVec3f(0.0, 0.0, -1.0), viewDirection);

  // Make sure all is in view in this direction
  viewer->viewAll();

  return viewer;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Mainline
//

int main(int argc, char **argv)
  //
  ////////////////////////////////////////////////////////////////////////
{
  SoInput		in;
  SoNode		*root;
  SoXtPlaneViewer	*topViewer, *frontViewer, *rightViewer;
  SoXtExaminerViewer	*perspViewer;
  Widget		form, topWidget, frontWidget, rightWidget, perspWidget;
  int			argN;
  Arg			args[20];

  if (argc != 2) {
    printUsage(argv[0]);
    return 1;
  }

  // Init Inventor
  Widget mainWindow = SoXt::init(argv[0]);

  // Open and read input scene graph
  if (! in.openFile(argv[1])) {
    fprintf(stderr, "%s: Cannot open %s\n", argv[0], argv[1]);
    return 1;
  }
  SoWWWInline::setReadAsSoFile(TRUE);

  root = SoDB::readAll(&in);
  if (root == NULL) {
    fprintf(stderr, "%s: Problem reading data\n", argv[0]);
    return 1;
  }

  root->ref();

  // Create a form widget to hold the viewers
  form = XmCreateForm(mainWindow, (char *)"form", NULL, 0);

  // Build each of the four viewers
  topViewer   = createPlaneViewer(form, "Top View",   root,
				  SbVec3f(0., -1.,  0.));
  frontViewer = createPlaneViewer(form, "Front View", root,
				  SbVec3f(0.,  0., -1.));
  rightViewer = createPlaneViewer(form, "Right View", root,
				  SbVec3f(-1., 0.,  0.));
  perspViewer = new SoXtExaminerViewer(form);
  perspViewer->setSceneGraph(root);

  // Viewers have the scene, so we don't need it here any more
  root->unref();

  // Get the widgets for the viewers
  topWidget   = topViewer->getWidget();
  frontWidget = frontViewer->getWidget();
  rightWidget = rightViewer->getWidget();
  perspWidget = perspViewer->getWidget();


  // Arrange the viewer's widgets in the form
  argN = 0;
  XtSetArg(args[argN], XmNtopAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNtopOffset,		0);			argN++;
  XtSetArg(args[argN], XmNleftAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNleftOffset,		0);			argN++;
  XtSetArg(args[argN], XmNrightAttachment,	XmATTACH_POSITION);	argN++;
  XtSetArg(args[argN], XmNrightPosition,	50);			argN++;
  XtSetArg(args[argN], XmNbottomAttachment,	XmATTACH_POSITION);	argN++;
  XtSetArg(args[argN], XmNbottomPosition,	50);			argN++;
  XtSetValues(topWidget, args, argN);

  argN = 0;
  XtSetArg(args[argN], XmNbottomAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNbottomOffset,	0);			argN++;
  XtSetArg(args[argN], XmNleftAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNleftOffset,		0);			argN++;
  XtSetArg(args[argN], XmNrightAttachment,	XmATTACH_POSITION);	argN++;
  XtSetArg(args[argN], XmNrightPosition,	50);			argN++;
  XtSetArg(args[argN], XmNtopAttachment,	XmATTACH_WIDGET);	argN++;
  XtSetArg(args[argN], XmNtopWidget,		topWidget);		argN++;
  XtSetValues(frontWidget, args, argN);
    
  argN = 0;
  XtSetArg(args[argN], XmNtopAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNtopOffset,		0);			argN++;
  XtSetArg(args[argN], XmNrightAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNrightOffset,	0);			argN++;
  XtSetArg(args[argN], XmNleftAttachment,	XmATTACH_WIDGET);	argN++;
  XtSetArg(args[argN], XmNleftWidget,		topWidget);		argN++;
  XtSetArg(args[argN], XmNbottomAttachment,	XmATTACH_POSITION);	argN++;
  XtSetArg(args[argN], XmNbottomPosition,	50);			argN++;
  XtSetValues(rightWidget, args, argN);

  argN = 0;
  XtSetArg(args[argN], XmNbottomAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNbottomOffset,	0);			argN++;
  XtSetArg(args[argN], XmNrightAttachment,	XmATTACH_FORM);		argN++;
  XtSetArg(args[argN], XmNrightOffset,	0);			argN++;
  XtSetArg(args[argN], XmNleftAttachment,	XmATTACH_WIDGET);	argN++;
  XtSetArg(args[argN], XmNleftWidget,		frontWidget);		argN++;
  XtSetArg(args[argN], XmNtopAttachment,	XmATTACH_WIDGET);	argN++;
  XtSetArg(args[argN], XmNtopWidget,		rightWidget);		argN++;
  XtSetValues(perspWidget, args, argN);

  // Show the widgets
  XtManageChild(form);
  topViewer->show();
  frontViewer->show();
  rightViewer->show();
  perspViewer->show();
  SoXt::show(mainWindow);

  // Enter the main loop
  SoXt::mainLoop();
}


