/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 2, example 1.
 *
 *  Hello Cone example program; draws a red cone in a window.
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>


int
main(int, char **argv)
{
  // Initialize Inventor. This returns a main window to use.
  // If unsuccessful, exit.
  Widget myWindow = SoXt::init(argv[0]); // pass the app name
  if (myWindow == NULL) 
    return 1;
  
  // Make a scene containing a red cone
  SoSeparator *root = new SoSeparator;
  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;
  SoMaterial *myMaterial = new SoMaterial;
  root->ref();
  root->addChild(myCamera);
  root->addChild(new SoDirectionalLight);
  myMaterial->diffuseColor.setValue(1.0, 0.0, 0.0);   // Red
  root->addChild(myMaterial);
  root->addChild(new SoCone);
  
  // Create a renderArea in which to see our scene graph.
  // The render area will appear within the main window.
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);
  
  // Make myCamera see everything.
  myCamera->viewAll(root, myRenderArea->getViewportRegion());
  
  // Put our scene in myRenderArea, change the title
  myRenderArea->setSceneGraph(root);
  myRenderArea->setTitle("Hello Cone");
  myRenderArea->show();
  
  SoXt::show(myWindow);  // Display main window
  SoXt::mainLoop();      // Main Inventor event loop

  delete myRenderArea;

  root->unref();

  SoXt::finish();

  return 0;
}


