/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*--------------------------------------------------------------
 *  This is an example from the Inventor Mentor,
 *  chapter 3, example 1.
 *
 *  This code shows how to create a molecule out of 3 spherical
 *  atoms.  The molecule illustrates how the ordering of nodes
 *  within a scene graph affects the rendered image.
 *
 *------------------------------------------------------------*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoTransform.h>

SoGroup *
makeWaterMolecule()
{
  //////////////////////////////////////////////////////////////
  // CODE FOR The Inventor Mentor STARTS HERE
  
  // Construct all parts
  SoGroup *waterMolecule = new SoGroup;  // water molecule
  
  SoGroup *oxygen = new SoGroup;         // oxygen atom
  SoMaterial *redPlastic = new SoMaterial;
  SoSphere *sphere1 = new SoSphere;
  
  SoGroup *hydrogen1 = new SoGroup;      // hydrogen atoms
  SoGroup *hydrogen2 = new SoGroup;
  SoTransform *hydrogenXform1 = new SoTransform;
  SoTransform *hydrogenXform2 = new SoTransform;
  SoMaterial *whitePlastic = new SoMaterial;
  SoSphere *sphere2 = new SoSphere;
  SoSphere *sphere3 = new SoSphere;
  
  // Set all field values for the oxygen atom
  redPlastic->ambientColor.setValue(1.0f, 0.0f, 0.0f);  
  redPlastic->diffuseColor.setValue(1.0f, 0.0f, 0.0f); 
  redPlastic->specularColor.setValue(0.5f, 0.5f, 0.5f);
  redPlastic->shininess = 0.5;
  
  // Set all field values for the hydrogen atoms
  hydrogenXform1->scaleFactor.setValue(0.75f, 0.75f, 0.75f);  
  hydrogenXform1->translation.setValue(0.0f, -1.2f, 0.0f);  
  hydrogenXform2->translation.setValue(1.1852f, 1.3877f, 0.0f);
  whitePlastic->ambientColor.setValue(1.0f, 1.0f, 1.0f);  
  whitePlastic->diffuseColor.setValue(1.0f, 1.0f, 1.0f); 
  whitePlastic->specularColor.setValue(0.5f, 0.5f, 0.5f);
  whitePlastic->shininess = 0.5;
  
  // Create a hierarchy
  waterMolecule->addChild(oxygen);   
  waterMolecule->addChild(hydrogen1);   
  waterMolecule->addChild(hydrogen2);
  
  oxygen->addChild(redPlastic);
  oxygen->addChild(sphere1);
  hydrogen1->addChild(hydrogenXform1);
  hydrogen1->addChild(whitePlastic);
  hydrogen1->addChild(sphere2);
  hydrogen2->addChild(hydrogenXform2);
  hydrogen2->addChild(sphere3);
  
  // CODE FOR The Inventor Mentor ENDS HERE
  //////////////////////////////////////////////////////////////
  
  return waterMolecule;
}


int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);
  
  SoSeparator *root = new SoSeparator;
  root->ref();
  
  // This function contains our code fragment.
  root->addChild(makeWaterMolecule());
  
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("H two O");
  myViewer->show();
  myViewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete myViewer;

  SoXt::finish();

  return 0;
}



